/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.permissions;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import com.radiantminds.roadmap.common.extensions.users.UserData;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPluginAdminAccess;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.permissions.RestPermission;
import com.radiantminds.roadmap.common.rest.services.permissions.PermissionEnrichments;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;

public interface PluginPermissionServiceHandler {
    @AuthorizedPluginAdminAccess
    public Response setPermission(RestPermission var1) throws Exception;

    @AuthorizedPluginAdminAccess
    public Response deletePermission(String var1) throws Exception;

    @AuthorizedPluginAdminAccess
    public Response getPermissions(String var1) throws Exception;

    public static class Impl
    implements PluginPermissionServiceHandler {
        private final UserExtension userExtension;
        private final PortfolioPermissionPersistence permissionPersistence;

        protected Impl(PortfolioPermissionPersistence permissionPersistence, UserExtension userExtension) {
            this.permissionPersistence = permissionPersistence;
            this.userExtension = userExtension;
        }

        @Override
        public Response setPermission(RestPermission permission) throws Exception {
            if (!Predicates.in((Collection)Sets.newHashSet((Object[])new String[]{"admin", "user", "editor-nonpub", "viewer", "labs", "team-mgmt"})).apply((Object)permission.getTargetId())) {
                return ResponseBuilder.badRequest(RestMessaging.error("unsupported permission id"));
            }
            permission.setTargetType("system");
            UserData currentUser = this.userExtension.getActiveUserData();
            if ("group".equals(permission.getHolderType()) && this.userExtension.doesGroupSysadminRestrictionApply(currentUser, permission.getHolderId())) {
                return ResponseBuilder.badRequest(RestMessaging.error("permission to denied to set this user group."));
            }
            IPermission stored = this.permissionPersistence.persist(permission);
            return ResponseBuilder.ok(new ModificationResult(stored));
        }

        @Override
        public Response deletePermission(String permissionId) throws Exception {
            boolean success;
            IPermission permission = (IPermission)this.permissionPersistence.get(permissionId);
            if (permission == null) {
                return ResponseBuilder.notFound();
            }
            if (!"system".equals(permission.getTargetType())) {
                ResponseBuilder.badRequest(RestMessaging.error("not a plugin permission"));
            }
            if (success = this.permissionPersistence.delete(permissionId, false)) {
                return ResponseBuilder.noContent();
            }
            return ResponseBuilder.badRequest();
        }

        @Override
        public Response getPermissions(String targetId) throws Exception {
            List<IPermission> permissions = PluginPermissions.getSecuredPermissions(this.permissionPersistence, this.userExtension, targetId);
            List<RestPermission> retVal = ToRest.transferList(RestPermission.class, IPermission.class, permissions);
            if (this.userExtension != null) {
                PermissionEnrichments.enrichPermissions(retVal, this.userExtension);
            }
            return ResponseBuilder.okForArray(Iterables.toArray(retVal, RestPermission.class));
        }
    }
}

