/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.CyclicDependencyViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class CylceViolationDetector {
    CylceViolationDetector() {
    }

    Set<IScheduleViolation> createCycleViolations(Map<SchedulingWorkItem, Set<SchedulingWorkItem>> transitivePrerequisites) {
        Set<SchedulingWorkItem> items = this.getCyclics(transitivePrerequisites);
        HashSet scheduleViolations = Sets.newHashSet();
        for (SchedulingWorkItem item : items) {
            CyclicDependencyViolation scheduleViolation = new CyclicDependencyViolation(item.getId());
            scheduleViolations.add(scheduleViolation);
        }
        return scheduleViolations;
    }

    private Set<SchedulingWorkItem> getCyclics(Map<SchedulingWorkItem, Set<SchedulingWorkItem>> transitivePrerequisites) {
        HashSet cyclicItems = Sets.newHashSet();
        ArrayList entryList = Lists.newArrayList(transitivePrerequisites.entrySet());
        for (int i = 0; i < entryList.size(); ++i) {
            Map.Entry entry1 = (Map.Entry)entryList.get(i);
            SchedulingWorkItem item1 = (SchedulingWorkItem)entry1.getKey();
            if (((Set)entry1.getValue()).contains(item1)) {
                cyclicItems.add(item1);
            }
            if (i == entryList.size() - 1) break;
            for (int j = i + 1; j < entryList.size(); ++j) {
                Map.Entry entry2 = (Map.Entry)entryList.get(j);
                if (!((Set)entry1.getValue()).contains(entry2.getKey()) || !((Set)entry2.getValue()).contains(entry1.getKey())) continue;
                cyclicItems.add(entry1.getKey());
                cyclicItems.add(entry2.getKey());
            }
        }
        return cyclicItems;
    }
}

