/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.filters;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchParametersBuilder;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.query.Query;

public final class JiraIssueFilterUtil {
    private static final Log LOGGER = Log.with(JiraIssueFilterUtil.class);
    private final SearchRequestService searchRequestService;

    public JiraIssueFilterUtil(SearchRequestService searchRequestService) {
        this.searchRequestService = searchRequestService;
    }

    SearchRequest getFilter(ApplicationUser user, Long filterId) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        return this.searchRequestService.getFilter((JiraServiceContext)context, filterId);
    }

    SharedEntitySearchResult<SearchRequest> getFilters(ApplicationUser user, String queryString, int maxFilters) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        try {
            SharedEntitySearchResult result = this.searchRequestService.search((JiraServiceContext)context, JiraIssueFilterUtil.buildSearchParameters(queryString), 0, maxFilters);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse filter string.", new Object[0]);
            LOGGER.exception(e, Log.LogLevel.ERROR);
            return null;
        }
    }

    private static SharedEntitySearchParameters buildSearchParameters(String queryString) {
        SharedEntitySearchParametersBuilder builder = new SharedEntitySearchParametersBuilder();
        builder.setTextSearchMode(SharedEntitySearchParameters.TextSearchMode.WILDCARD);
        if (queryString != null) {
            builder.setName(queryString);
        }
        return builder.toSearchParameters();
    }

    static boolean isQueryValid(Query query) {
        return query != null && query.getQueryString() != null;
    }
}

