/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.extensions.workitems.IssueInfo;
import com.radiantminds.roadmap.common.extensions.workitems.StatusData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.JiraLinkEnrichmentData;

public class LinkEnrichmentData
implements JiraLinkEnrichmentData {
    private final StatusData statusData;
    private final Long timeSpent;
    private final double timeSumOrZero;
    private final double donePercentage;

    LinkEnrichmentData(StatusData statusInfo, Long timeSpent, double timeSumOrZero, double donePercentage) {
        this.statusData = statusInfo;
        this.timeSpent = timeSpent;
        this.timeSumOrZero = timeSumOrZero;
        this.donePercentage = donePercentage;
    }

    public static JiraLinkEnrichmentData create(IssueInfo issueInfo) {
        StatusData statusInfo = issueInfo.getStatus();
        Long timeSpent = issueInfo.getTimeSpent();
        Long remaining = issueInfo.getRemainingEstimate();
        Optional<Long> sum = RmUtils.getOptionalSum(timeSpent, remaining);
        double donePercentage = LinkEnrichmentData.calculateDonePercentage((Long)sum.or((Object)0L), timeSpent);
        return new LinkEnrichmentData(statusInfo, timeSpent, ((Long)sum.or((Object)0L)).doubleValue(), donePercentage);
    }

    @Override
    public double getTimeDonePercentage() {
        return this.donePercentage;
    }

    @Override
    public double getTimeSumOrZero() {
        return this.timeSumOrZero;
    }

    @Override
    public Long getTimeSpent() {
        return this.timeSpent;
    }

    @Override
    public String getId() {
        return this.statusData.getId();
    }

    @Override
    public String getName() {
        return this.statusData.getName();
    }

    @Override
    public String getIconUrl() {
        return this.statusData.getIconUrl();
    }

    @Override
    public Optional<String> getCategoryKey() {
        return this.statusData.getCategoryKey();
    }

    @Override
    public Optional<String> getCategoryColor() {
        return this.statusData.getCategoryColor();
    }

    @Override
    public boolean isDone() {
        return this.statusData.isDone();
    }

    private static double calculateDonePercentage(Long timeSum, Long spent) {
        if (timeSum == 0L || spent == null) {
            return 0.0;
        }
        return spent.doubleValue() / (double)timeSum.longValue();
    }
}

