/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PlanInformation;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.StageInformation;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.StoryPointEstimateSyncTaskFactory;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.SyncTaskFactory;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.TimeEstimateSyncTaskFactory;
import com.radiantminds.roadmap.jira.common.components.utils.TimeTracking;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.JiraAgileCustomFieldData;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class EstimateSyncTaskFactoryProvider {
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final LocaleManager localeManager;

    @Autowired
    public EstimateSyncTaskFactoryProvider(ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, LocaleManager localeManager) {
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.localeManager = localeManager;
    }

    public SyncTaskFactory createFactory(StageInformation stageInformation, PlanInformation planInformation, Optional<JiraAgileCustomFieldData> customFieldData) {
        if (planInformation.getPlanningUnit() == PlanningUnit.STORY_POINTS) {
            if (customFieldData.isPresent()) {
                Locale locale = this.localeManager.getLocaleFor(this.authenticationContext.getUser());
                return new StoryPointEstimateSyncTaskFactory(stageInformation, (JiraAgileCustomFieldData)customFieldData.get(), locale);
            }
            return SyncTaskFactory.NO_TASK_FACTORY;
        }
        boolean legacyTimeTrackingMode = TimeTracking.isLegacyMode(this.applicationProperties);
        return new TimeEstimateSyncTaskFactory(stageInformation, planInformation, legacyTimeTrackingMode);
    }
}

