/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentCandidateFactory;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.BoundAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.DefaultSubAssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.ImmutableAssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.SubAssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.atlassian.rm.jpo.scheduling.util.search.SearchState;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AssignmentSearchState
implements SearchState<AssignmentCandidate> {
    private static final int TIME_PENALTY_FACTOR = 10000;
    private static final AssignmentCandidateFactory CANDIDATE_FACTORY = new AssignmentCandidateFactory();
    private final AssignmentCandidate candidate;
    private final float cost;
    private final BoundAssignmentProblem problem;

    private AssignmentSearchState(AssignmentCandidate candidate, float cost, BoundAssignmentProblem problem) {
        this.candidate = candidate;
        this.cost = cost;
        this.problem = problem;
    }

    @Override
    public AssignmentCandidate getCandidate() {
        return this.candidate;
    }

    @Override
    public float getCost() {
        return this.cost;
    }

    @Override
    public SearchState<AssignmentCandidate> createAddTime() throws InterruptedException {
        AssignmentCandidate nextCandidate = CANDIDATE_FACTORY.createAddTime(this.candidate, this.problem);
        return new AssignmentSearchState(nextCandidate, AssignmentSearchState.calculateAssignmentCost(nextCandidate), this.problem);
    }

    @Override
    public SearchState<AssignmentCandidate> createNextTime() throws InterruptedException {
        int nextTime = this.candidate.getTimeIndices().get(this.candidate.getTimeIndices().size() - 1) + 1;
        ImmutableAssignmentCandidate newCandidate = new ImmutableAssignmentCandidate(this.candidate.getSubAssignmentCandidates(), Lists.newArrayList((Object[])new Integer[]{nextTime}), this.candidate.getResourceCosts(), this.calculateAvailabilities(nextTime), this.candidate.getSortKey(), this.problem.isSyncStart(), this.problem.getOverallDemand());
        return new AssignmentSearchState(newCandidate, AssignmentSearchState.calculateAssignmentCost(newCandidate), this.problem);
    }

    private PositivePrimitivesMap<AssignmentResource> calculateAvailabilities(int nextTime) {
        MutablePositivePrimitivesMap<AssignmentResource> availabilities = RmCollectionUtils.newMutablePositiveMap();
        for (AssignmentResource resource : this.candidate.getResourceCosts().keySet()) {
            availabilities.add(resource, resource.getUnassignedWorkInWorkSlot(nextTime));
        }
        return availabilities;
    }

    public static AssignmentSearchState create(List<Set<AssignmentResource>> combinations, BoundAssignmentProblem problem, int timeIndex) throws InterruptedException {
        List<SubAssignmentCandidate> subAssignmentCandidates = AssignmentSearchState.createSubAssignmentCandidates(combinations, problem);
        ImmutableAssignmentCandidate candidate = AssignmentCandidateFactory.createInstance(subAssignmentCandidates, timeIndex, problem);
        return new AssignmentSearchState(candidate, AssignmentSearchState.calculateAssignmentCost(candidate), problem);
    }

    private static float calculateAssignmentCost(AssignmentCandidate solutionCandidate) {
        return (float)(solutionCandidate.getLatestTime() * 10000) + solutionCandidate.getResourceCosts().getValueSum();
    }

    private static List<SubAssignmentCandidate> createSubAssignmentCandidates(List<Set<AssignmentResource>> combinations, BoundAssignmentProblem problem) {
        ArrayList subCandidates = Lists.newArrayListWithCapacity((int)combinations.size());
        for (int i = 0; i < combinations.size(); ++i) {
            subCandidates.add(new DefaultSubAssignmentCandidate(combinations.get(i), problem.getStageTaskProblems().get(i)));
        }
        return subCandidates;
    }
}

