/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.AvailabilityConstraint;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.DemandConstraint;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpAssignmentVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpAssignmentVariableImpl;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.WeightedAssignmentLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.DefaultConstraint;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.ImmutableUnweightedAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.ImmutableWeightedAssignmentLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.SubAssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PrimitivesMap;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WeightedAssignmentLpProblemCreator {
    private static final Log LOGGER = Log.with(WeightedAssignmentLpProblemCreator.class);

    Optional<ImmutableWeightedAssignmentLpProblem> tryCreate(AssignmentCandidate candidate) {
        if (candidate.isStaticallyUnsolvable()) {
            return Optional.absent();
        }
        List<LpAssignmentVariable> variables = WeightedAssignmentLpProblemCreator.createVariables(candidate);
        ImmutableUnweightedAssignmentProblem instance = new ImmutableUnweightedAssignmentProblem(variables, WeightedAssignmentLpProblemCreator.createDemandConstraints(candidate, variables), WeightedAssignmentLpProblemCreator.createAvailabilityConstraints(candidate.getAggregatedAvailabilities(), variables));
        ImmutableWeightedAssignmentLpProblem weightedProblem = new ImmutableWeightedAssignmentLpProblem(instance, WeightedAssignmentLpProblemCreator.createResourceCosts(variables, candidate.getResourceCosts()));
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return Optional.of((Object)weightedProblem);
    }

    private static double[] createResourceCosts(List<LpAssignmentVariable> variables, PrimitivesMap<AssignmentResource> resourceCosts) {
        double[] costs = new double[variables.size()];
        for (int i = 0; i < variables.size(); ++i) {
            costs[i] = resourceCosts.get(variables.get(i).getResource());
        }
        return costs;
    }

    private static List<AvailabilityConstraint> createAvailabilityConstraints(PositivePrimitivesMap<AssignmentResource> availabilities, List<LpAssignmentVariable> variables) {
        ArrayList constraints = Lists.newArrayListWithCapacity((int)availabilities.size());
        for (AssignmentResource resource : RmSortableUtils.sort(availabilities.keySet())) {
            Set<Integer> resourceIndices = WeightedAssignmentLpProblemCreator.getResourceIndices(resource, variables);
            constraints.add(new DefaultConstraint(resourceIndices, availabilities.get(resource)));
        }
        return constraints;
    }

    private static Set<Integer> getResourceIndices(AssignmentResource resource, List<LpAssignmentVariable> variables) {
        HashSet indices = Sets.newHashSet();
        for (int i = 0; i < variables.size(); ++i) {
            if (!resource.equals(variables.get(i).getResource())) continue;
            indices.add(i);
        }
        return indices;
    }

    private static List<DemandConstraint> createDemandConstraints(AssignmentCandidate candidate, List<LpAssignmentVariable> variables) {
        ArrayList constraints = Lists.newArrayList();
        for (SubAssignmentCandidate subAssignmentCandidate : candidate.getSubAssignmentCandidates()) {
            PositivePrimitivesMap<IResourceType> demand = subAssignmentCandidate.getDemand();
            for (IResourceType type : RmSortableUtils.sort(subAssignmentCandidate.getDemand().keySet())) {
                constraints.add(new DefaultConstraint(WeightedAssignmentLpProblemCreator.getSubTaskTypeIndices(subAssignmentCandidate.getId(), type, variables), demand.get(type)));
            }
        }
        return constraints;
    }

    private static Set<Integer> getSubTaskTypeIndices(String taskId, IResourceType type, List<LpAssignmentVariable> variables) {
        HashSet indices = Sets.newHashSet();
        for (int i = 0; i < variables.size(); ++i) {
            if (!taskId.equals(variables.get(i).getStageTask()) || !type.equals(variables.get(i).getTypeId())) continue;
            indices.add(i);
        }
        return indices;
    }

    private static List<LpAssignmentVariable> createVariables(AssignmentCandidate candidate) {
        ArrayList variables = Lists.newArrayList();
        List<SubAssignmentCandidate> subAssignmentCandidates = candidate.getSubAssignmentCandidates();
        for (SubAssignmentCandidate subAssignmentCandidate : subAssignmentCandidates) {
            Set<AssignmentResource> combination = subAssignmentCandidate.getCombination();
            PositivePrimitivesMap<IResourceType> demand = subAssignmentCandidate.getDemand();
            for (AssignmentResource resource : RmSortableUtils.sort(combination)) {
                if (!candidate.getAggregatedAvailabilities().containsKey(resource)) continue;
                Sets.SetView relevantTypes = Sets.intersection(resource.getTypes(), demand.keySet());
                for (IResourceType type : RmSortableUtils.sort(relevantTypes)) {
                    variables.add(new LpAssignmentVariableImpl(resource, type, subAssignmentCandidate.getId()));
                }
            }
            subAssignmentCandidate.getId();
        }
        return variables;
    }

    public Optional<WeightedAssignmentLpProblem> createFeasibilityProblem(PositivePrimitivesMap<AssignmentResource> availabilities, PositivePrimitivesMap<IResourceType> demands) {
        List<LpAssignmentVariable> variables = this.createVariables(availabilities, demands);
        List<DemandConstraint> demandConstraints = this.createUnsortedDemandConstraints(demands, variables);
        List<AvailabilityConstraint> availabilityConstraints = WeightedAssignmentLpProblemCreator.createAvailabilityConstraints(availabilities, variables);
        ImmutableUnweightedAssignmentProblem instance = new ImmutableUnweightedAssignmentProblem(variables, demandConstraints, availabilityConstraints);
        ImmutableWeightedAssignmentLpProblem weightedProblem = new ImmutableWeightedAssignmentLpProblem(instance, new double[variables.size()]);
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return Optional.of((Object)weightedProblem);
    }

    private List<DemandConstraint> createUnsortedDemandConstraints(PositivePrimitivesMap<IResourceType> demands, List<LpAssignmentVariable> variables) {
        ArrayList constraints = Lists.newArrayList();
        for (IResourceType type : demands.keySet()) {
            constraints.add(new DefaultConstraint(WeightedAssignmentLpProblemCreator.getSubTaskTypeIndices("", type, variables), demands.get(type)));
        }
        return constraints;
    }

    private List<LpAssignmentVariable> createVariables(PositivePrimitivesMap<AssignmentResource> availabilities, PositivePrimitivesMap<IResourceType> demands) {
        ArrayList variables = Lists.newArrayList();
        for (AssignmentResource resource : availabilities.keySet()) {
            Sets.SetView relevantTypes = Sets.intersection(resource.getTypes(), demands.keySet());
            for (IResourceType type : RmSortableUtils.sort(relevantTypes)) {
                variables.add(new LpAssignmentVariableImpl(resource, type, ""));
            }
        }
        return variables;
    }
}

