/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.sql;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.skills.ISkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.people.AOAbility;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.rest.entities.skills.RestSkill;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SkillSQL
extends BaseAOPersistenceSQL {
    public SkillSQL(ActiveObjectsUtilities activeObjectsUtilities) {
        super(activeObjectsUtilities);
    }

    public List<String> getSkillIdsForStage(final String stageId) throws SQLException {
        return this.sql(new IQuery<List<String>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOSkill.class, "s").select().col("s", "ID_OTHER", false).from("s").where().col("s", "aostage").eq().numeric(stageId);
            }

            @Override
            public List<String> handleResult(ResultSet result) throws Exception {
                ArrayList retVal = Lists.newArrayList();
                while (result.next()) {
                    retVal.add(BaseAOPersistenceSQL.getString(result, 1));
                }
                return retVal;
            }
        });
    }

    public List<ISkill> getSkillsForStage(final String stageId) throws SQLException {
        return this.sql(new IQuery<List<ISkill>>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOSkill.class, "skill").select().col("skill", "ID_OTHER", false).col("skill", "version").col("skill", "title").col("skill", "details").col("skill", "percentage").col("skill", "sortOrder").from("skill").where().col("skill", "aostage").eq().numeric(stageId).orderBy().col("skill", "sortOrder");
            }

            @Override
            public List<ISkill> handleResult(ResultSet result) throws Exception {
                ArrayList skills = Lists.newArrayList();
                while (result.next()) {
                    String skillId = BaseAOPersistenceSQL.getString(result, 1);
                    Long version = SkillSQL.getLong(result, 2);
                    String title = BaseAOPersistenceSQL.getString(result, 3);
                    String description = BaseAOPersistenceSQL.getString(result, 4);
                    Double percentage = BaseAOPersistenceSQL.getDouble(result, 5);
                    Long sortOrder = SkillSQL.getLong(result, 6);
                    RestSkill skill = new RestSkill(skillId, title, description);
                    skill.setVersion(version);
                    skill.setPercentage(percentage);
                    skill.setSortOrder(sortOrder);
                    skills.add(skill);
                }
                return skills;
            }
        });
    }

    public void deleteAllSkillAbilities(final String id) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOAbility.class, "t").deleteFrom().tableNoAlias("t").where().colNoAlias("t", "targetType").eq().str("skill").and().colNoAlias("t", "targetId").eq().numeric(id);
            }
        });
    }
}

