/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.workitems;

import com.radiantminds.roadmap.common.extensions.workitems.IsEstimatedFunction;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import java.util.Collection;

public class EstimateRatioData {
    private static final IsEstimatedFunction IS_ESTIMATED = new IsEstimatedFunction();
    private final int estimatedCount;
    private final int unestimatedCount;

    public EstimateRatioData(int estimatedCount, int unestimatedCount) {
        this.estimatedCount = estimatedCount;
        this.unestimatedCount = unestimatedCount;
    }

    public int getEstimatedCount() {
        return this.estimatedCount;
    }

    public int getUnestimatedCount() {
        return this.unestimatedCount;
    }

    public static EstimateRatioData create(Collection<ProgressData> values) {
        int estimated = 0;
        int unestimated = 0;
        for (ProgressData value : values) {
            if (IS_ESTIMATED.apply(value).booleanValue()) {
                ++estimated;
                continue;
            }
            ++unestimated;
        }
        return new EstimateRatioData(estimated, unestimated);
    }
}

