/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.teams.velocity;

import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.services.teams.velocity.TeamVelocityServiceHandler;
import com.radiantminds.roadmap.common.scheduling.entities.SchedulingPlanFactory;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/teams/{id}/forecast")
@Component
public class TeamVelocityForecastService {
    private final TeamVelocityServiceHandler handler;

    @Autowired
    public TeamVelocityForecastService(SecuredInvocationHandlerFactory handlerFactory, SchedulingPlanFactory schedulingPlanFactory, PortfolioTeamPersistence teamPersistence) {
        this.handler = handlerFactory.createProxy(TeamVelocityServiceHandler.class, new TeamVelocityServiceHandler.Impl(teamPersistence, schedulingPlanFactory), teamPersistence);
    }

    @GET
    public Response getVelocityForecast(@PathParam(value="id") String teamId, @QueryParam(value="count") int count, @QueryParam(value="velocity") Double velocity, @QueryParam(value="increment") Double increment, @QueryParam(value="adjustToAbsences") Boolean adjustToAbsences) throws Exception {
        if (adjustToAbsences == null) {
            adjustToAbsences = false;
        }
        return this.handler.getVelocityForecast(EntityContext.from(teamId), count, velocity, increment, adjustToAbsences);
    }
}

