/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.release;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisodeStream;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.ITimePlan;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.TimePlan;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingStream;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.release.StreamTransformer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TimePlanTransformer {
    private final StreamTransformer streamTransformer;

    TimePlanTransformer(StreamTransformer streamTransformer) {
        this.streamTransformer = streamTransformer;
    }

    public TimePlanTransformer(ITimeTransformer timeTransformer) {
        this(new StreamTransformer(timeTransformer));
    }

    public ITimePlan transformTimePlan(SchedulingPlan plan, Set<String> availableResourceGroupIds) {
        HashSet episodeStreams = Sets.newHashSet();
        List<? extends SchedulingStream> streams = plan.getStreams();
        for (SchedulingStream schedulingStream : streams) {
            IEpisodeStream episodeStream = this.streamTransformer.transform(schedulingStream, availableResourceGroupIds);
            episodeStreams.add(episodeStream);
        }
        TimePlan timePlan = new TimePlan(episodeStreams);
        return timePlan;
    }
}

