/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridge;
import com.atlassian.rm.common.bridges.jira.issue.IssueServiceBridgeProxy;
import com.radiantminds.roadmap.jira.common.components.issues.sync.SyncTask;
import com.radiantminds.roadmap.jira.common.components.utils.JiraUserUtil;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class JiraIssueUpdater {
    private static final Log LOGGER = Log.with(JiraIssueUpdater.class);
    private final JiraAuthenticationContext authenticationContext;
    private final IssueService issueService;
    private final IssueServiceBridgeProxy issueServiceBridgeProxy;

    @Autowired
    public JiraIssueUpdater(JiraAuthenticationContext authenticationContext, IssueService issueService, IssueServiceBridgeProxy issueServiceBridgeProxy) {
        this.authenticationContext = authenticationContext;
        this.issueService = issueService;
        this.issueServiceBridgeProxy = issueServiceBridgeProxy;
    }

    public void updateIssue(Set<SyncTask> syncTasks, String portfolioID, String jiraKey) {
        ApplicationUser user = JiraUserUtil.getCurrentApplicationUser(this.authenticationContext);
        IssueServiceBridge issueServiceBridge = (IssueServiceBridge)this.issueServiceBridgeProxy.get();
        IssueService.IssueResult issueResult = issueServiceBridge.getIssue(user, jiraKey);
        if (!issueResult.isValid()) {
            LOGGER.info("Unable to sync to issue %s; it could not be retrieved.", jiraKey);
            JiraIssueUpdater.logErrorCollection(issueResult.getErrorCollection());
            return;
        }
        MutableIssue issue = issueResult.getIssue();
        IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters();
        issueInputParameters.setSkipScreenCheck(true);
        issueInputParameters.setRetainExistingValuesWhenParameterNotProvided(true, true);
        boolean modified = false;
        for (SyncTask syncTask : syncTasks) {
            modified |= syncTask.apply(issue, issueInputParameters);
        }
        if (modified) {
            LOGGER.info("Syncing Portfolio item '%s' to Jira issue '%s'...", portfolioID, jiraKey);
            IssueService.UpdateValidationResult validationResult = issueServiceBridge.validateUpdate(user, issue.getId(), issueInputParameters);
            if (!validationResult.isValid()) {
                LOGGER.info("Syncing Portfolio item to Jira issue failed on validation.", new Object[0]);
                JiraIssueUpdater.logErrorCollection(validationResult.getErrorCollection());
                return;
            }
            IssueService.IssueResult updateResult = issueServiceBridge.update(user, validationResult);
            if (!updateResult.isValid()) {
                LOGGER.info("Syncing Portfolio item to Jira issue failed on update.", new Object[0]);
                JiraIssueUpdater.logErrorCollection(updateResult.getErrorCollection());
                return;
            }
            LOGGER.info("Syncing Portfolio item to Jira issue successful.", new Object[0]);
        }
    }

    private static void logErrorCollection(ErrorCollection errorCollection) {
        if (errorCollection != null && errorCollection.getErrorMessages() != null && errorCollection.getErrorMessages().size() > 0) {
            LOGGER.info("Details:", new Object[0]);
            for (String error : errorCollection.getErrorMessages()) {
                LOGGER.info(error, new Object[0]);
            }
        }
    }
}

