/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.admin.export;

import com.atlassian.jira.action.admin.export.EntitiesExporter;
import com.atlassian.jira.action.admin.export.EntityXmlWriter;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.startup.FormattedLogMsg;
import com.atlassian.jira.startup.JiraSystemInfo;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSaxEntitiesExporter
implements EntitiesExporter {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final int DEFAULT_FETCH_SIZE = 1000;
    private static final Logger log = LoggerFactory.getLogger(DefaultSaxEntitiesExporter.class);
    @ClusterSafe
    private final ResettableLazyReference<EntityFindOptions> entityFindOptionsRef = new ResettableLazyReference<EntityFindOptions>(){

        protected EntityFindOptions create() throws Exception {
            return DefaultSaxEntitiesExporter.this.getFindOptions();
        }
    };
    private final OfBizDelegator delegator;
    private final ApplicationProperties applicationProperties;
    private final BuildUtilsInfo buildUtilsInfo;
    private final DatabaseConfigurationManager databaseConfigurationManager;

    public DefaultSaxEntitiesExporter(OfBizDelegator delegator, ApplicationProperties applicationProperties, BuildUtilsInfo buildUtilsInfo) {
        this(delegator, applicationProperties, buildUtilsInfo, (DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class));
    }

    public DefaultSaxEntitiesExporter(OfBizDelegator delegator, ApplicationProperties applicationProperties, BuildUtilsInfo buildUtilsInfo, DatabaseConfigurationManager databaseConfigurationManager) {
        this.delegator = (OfBizDelegator)Assertions.notNull((String)"delegator", (Object)delegator);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.databaseConfigurationManager = databaseConfigurationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long exportEntities(OutputStream outputStream, SortedSet<String> entityNames, EntityXmlWriter entityWriter, ApplicationUser exportingUser) throws IOException, GenericEntityException {
        this.entityFindOptionsRef.reset();
        long projectCount = ComponentAccessor.getProjectManager().getProjectCount();
        EntityCounter entityCounter = new EntityCounter();
        PrintWriter printWriter = this.getWriter(outputStream);
        this.writeHeader(printWriter, exportingUser);
        try {
            for (String curEntityName : entityNames) {
                log.debug("curEntityName = " + curEntityName);
                ModelEntity modelEntity = this.delegator.getModelReader().getModelEntity(curEntityName);
                if (!(modelEntity instanceof ModelViewEntity)) {
                    this.exportEntity(curEntityName, entityCounter, entityWriter, printWriter);
                    continue;
                }
                log.debug("No need to export entity '" + curEntityName + "' as it is a view entity.");
            }
            this.writeFooter(printWriter, entityCounter);
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
            }
        }
        return entityCounter.total.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportEntity(String curEntityName, EntityCounter entityCounter, EntityXmlWriter entityWriter, PrintWriter printWriter) throws GenericEntityException {
        EntityFindOptions findOptions = this.getFindOptions();
        boolean ok = false;
        Transaction transaction = Txn.begin();
        if (log.isDebugEnabled()) {
            log.debug("  inTransaction={}", (Object)(transaction.isNewTransaction() ? "NEW" : "JOINED"));
        }
        try (OfBizListIterator listIterator = this.delegator.findListIteratorByCondition(curEntityName, null, null, null, null, findOptions);){
            GenericValue genericValue = listIterator.next();
            while (genericValue != null) {
                entityWriter.writeXmlText(genericValue, printWriter);
                entityCounter.increment(curEntityName);
                genericValue = listIterator.next();
            }
            ok = true;
        }
        finally {
            this.cleanUpAfterEntity(transaction, ok);
        }
    }

    private void cleanUpAfterEntity(Transaction transaction, boolean ok) throws GenericEntityException {
        if (transaction.isNewTransaction()) {
            try {
                if (ok) {
                    transaction.commit();
                }
            }
            finally {
                transaction.finallyRollbackIfNotCommitted();
            }
        }
    }

    protected PrintWriter getWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, this.applicationProperties.getEncoding()), 32768));
    }

    protected void writeFooter(PrintWriter printWriter, EntityCounter entityCounter) {
        this.writeEntityCountComment(printWriter, entityCounter);
        printWriter.write("</entity-engine-xml>");
    }

    private void writeEntityCountComment(PrintWriter printWriter, EntityCounter entityCounter) {
        FormattedLogMsg logMsg = new FormattedLogMsg();
        try {
            entityCounter.outputToMessage(logMsg);
        }
        catch (RuntimeException rte) {
            log.error("An exception occuring while writing the JIRA system info end comment", (Throwable)rte);
            return;
        }
        printWriter.println("<!-- ");
        printWriter.println(this.escapeXmlComment(logMsg.toString()));
        printWriter.println(" -->");
    }

    protected void writeHeader(PrintWriter printWriter, ApplicationUser exportingUser) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + this.applicationProperties.getEncoding() + "\"?>");
        this.writeSysInfoComment(printWriter, exportingUser);
        printWriter.println(String.format("<entity-engine-xml date=\"%d\">", System.currentTimeMillis()));
    }

    private void writeSysInfoComment(PrintWriter printWriter, ApplicationUser exportingUser) {
        FormattedLogMsg logMsg = new FormattedLogMsg();
        try {
            DateFormat df = DateFormat.getDateTimeInstance(0, 0);
            String when = df.format(new Date());
            Object exportingUserName = "Unknown???";
            if (exportingUser != null) {
                exportingUserName = exportingUser.getName();
                if (exportingUser.getDisplayName() != null) {
                    exportingUserName = (String)exportingUserName + " ( " + exportingUser.getDisplayName() + " )";
                }
            }
            logMsg.outputHeader("Exported on");
            logMsg.outputProperty("on", when);
            logMsg.outputProperty("by", (String)exportingUserName);
            JiraSystemInfo info = new JiraSystemInfo(logMsg, this.buildUtilsInfo);
            info.obtainBasicInfo(null);
            info.obtainDatabaseConfigurationInfo();
            info.obtainJiraAppProperties();
            info.obtainDatabaseStatistics();
            info.obtainUpgradeHistory();
            info.obtainFilePaths();
            info.obtainPlugins();
            info.obtainListeners();
            info.obtainServices();
            info.obtainTrustedApps();
        }
        catch (RuntimeException rte) {
            log.error("An exception occuring while writing the JIRA system info start commment", (Throwable)rte);
            return;
        }
        printWriter.println("<!-- ");
        printWriter.println(this.escapeXmlComment(logMsg.toString()));
        printWriter.println(" -->");
    }

    private String escapeXmlComment(String xmlComment) {
        Object escapedComment = xmlComment;
        if (xmlComment.contains("--")) {
            escapedComment = ((String)escapedComment).replaceAll("--", "-:");
            escapedComment = "\nThe comment data contained one of more occurences of a '-' character followed immediately by another '-' character.\nThis is not allowed according to http://www.w3.org/TR/REC-xml/#dt-comment.\nThese have been replaced by '-:' characters to make the XML valid\n\n" + (String)escapedComment;
        }
        return escapedComment;
    }

    EntityFindOptions getFindOptions() {
        DatabaseConfig dbConfig = this.databaseConfigurationManager.getDatabaseConfiguration();
        int fetchSize = PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.export.fetchsize", (int)-1);
        if (fetchSize == -1) {
            fetchSize = dbConfig.isMySql() ? Integer.MIN_VALUE : 1000;
        }
        return EntityFindOptions.findOptions().fetchSize(fetchSize);
    }

    private static final class EntityCounter {
        Map<String, AtomicLong> map = new LinkedHashMap<String, AtomicLong>();
        AtomicLong total = new AtomicLong(0L);

        private EntityCounter() {
        }

        private void increment(String entityName) {
            AtomicLong count = this.map.get(entityName);
            if (count == null) {
                count = new AtomicLong(0L);
                this.map.put(entityName, count);
            }
            count.incrementAndGet();
            this.total.incrementAndGet();
        }

        private void outputToMessage(FormattedLogMsg logMsg) {
            logMsg.outputHeader("Entities");
            logMsg.outputProperty("Total", String.valueOf(this.total));
            logMsg.add("");
            for (Map.Entry<String, AtomicLong> entry : this.map.entrySet()) {
                logMsg.outputProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
    }
}

