/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.analytics;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class AnalyticsEvent {
    private final Map<Object, Object> total;
    private final Map<Object, Object> snapshot;

    protected AnalyticsEvent(@Nullable Map<Object, Object> snapshot, @Nullable Map<Object, Object> total) {
        this.snapshot = snapshot;
        this.total = total;
    }

    protected static Map<Object, Object> addDurationAsLong(@Nullable Map<Object, Object> statsMap) {
        Optional.ofNullable(statsMap).map(m -> m.get("_duration")).map(Object::toString).map(Duration::parse).map(Duration::toMillis).ifPresent(duration -> statsMap.put("durationInMillis", duration));
        return statsMap;
    }

    @Nullable
    public Map<Object, Object> getTotal() {
        return this.total;
    }

    @Nullable
    public Map<Object, Object> getSnapshot() {
        return this.snapshot;
    }
}

