/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.check.CheckAmendment;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.model.querydsl.QOSWorkflowEntry;
import com.atlassian.jira.model.querydsl.QProject;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WorkflowStateCheck
extends CheckImpl<CheckAmendment> {
    public WorkflowStateCheck(OfBizDelegator ofBizDelegator, QueryDslAccessor queryDslAccessor, int id) {
        super(ofBizDelegator, queryDslAccessor, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.workflow.state.check.desc");
    }

    @Override
    public List<CheckAmendment> preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List<CheckAmendment> correct() throws IntegrityException {
        return this.doCheck(true);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }

    private List<CheckAmendment> doCheck(boolean shouldCorrect) {
        List<CheckAmendment> results = this.checkForFaultyWorkflows();
        if (shouldCorrect) {
            this.correctFaultyWorkflows();
        }
        return results;
    }

    private void correctFaultyWorkflows() {
        this.queryDslAccessor.execute(connection -> {
            List affectedRecords = this.getFaultyWorkflowsIds(connection).fetch();
            connection.update((RelationalPath<?>)QOSWorkflowEntry.O_S_WORKFLOW_ENTRY).set(QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.state, (Object)1).where((Predicate)QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.id.in((Collection)affectedRecords)).execute();
        });
    }

    private List<CheckAmendment> checkForFaultyWorkflows() {
        ArrayList<CheckAmendment> results = new ArrayList<CheckAmendment>();
        List<Tuple> faultyWorkflows = this.getFaultyWorkflows();
        for (Tuple fetched : faultyWorkflows) {
            String issueKey = (String)fetched.get((Expression)QProject.PROJECT.key) + "-" + fetched.get(QIssue.ISSUE.number);
            String workflowId = ((Long)fetched.get(QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.id)).toString();
            String message = this.getI18NBean().getText("admin.integrity.check.workflow.state.check.preview", issueKey, workflowId);
            results.add(new CheckAmendment(2, message, "JRA-4241"));
        }
        return results;
    }

    private List<Tuple> getFaultyWorkflows() {
        Expression[] workflowIdWithIssueKey = new Expression[]{QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.id, QProject.PROJECT.key, QIssue.ISSUE.number};
        return this.queryDslAccessor.executeQuery(connection -> WorkflowStateCheck.buildFaultyWorkflowQuery(connection, workflowIdWithIssueKey).fetch());
    }

    private SQLQuery<Long> getFaultyWorkflowsIds(DbConnection connection) {
        Expression[] justIds = new Expression[]{QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.id};
        return WorkflowStateCheck.buildFaultyWorkflowQuery(connection, justIds).select(QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.id);
    }

    private static SQLQuery<Tuple> buildFaultyWorkflowQuery(DbConnection connection, Expression<?>[] selectedColumns) {
        return (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(selectedColumns).from((Expression)QOSWorkflowEntry.O_S_WORKFLOW_ENTRY)).leftJoin((EntityPath)QIssue.ISSUE)).on((Predicate)QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.id.eq(QIssue.ISSUE.workflowId))).leftJoin((EntityPath)QProject.PROJECT)).on((Predicate)QIssue.ISSUE.project.eq(QProject.PROJECT.id))).where((Predicate)QIssue.ISSUE.id.isNotNull().and((Predicate)QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.state.isNull().or((Predicate)QOSWorkflowEntry.O_S_WORKFLOW_ENTRY.state.eq((Object)0))));
    }
}

