/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.integritycheck;

import com.atlassian.jira.appconsistency.integrity.amendment.Amendment;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.appconsistency.integrity.integritycheck.IntegrityCheckerCommandResult;
import com.atlassian.jira.appconsistency.integrity.integritycheck.ProgressAwareIntegrityCheckerOperation;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.FixedSized;
import com.atlassian.jira.util.collect.Sized;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class IntegrityCheckerCallable
implements Callable<IntegrityCheckerCommandResult>,
ProvidesTaskProgress {
    private TaskProgressSink taskProgressSink;
    private final Logger log;
    private final I18nHelper i18nHelper;
    private final ProgressAwareIntegrityCheckerOperation integrityCheckerOperation;
    private final List<Long> checks;
    private final Map<String, String[]> contextParameters;

    public IntegrityCheckerCallable(Logger log, I18nHelper i18nHelper, ProgressAwareIntegrityCheckerOperation integrityCheckerOperation, List<Long> checks, Map<String, String[]> contextParameters) {
        this.log = log;
        this.i18nHelper = i18nHelper;
        this.integrityCheckerOperation = integrityCheckerOperation;
        this.checks = checks;
        this.contextParameters = contextParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntegrityCheckerCommandResult call() {
        IntegrityCheckerCommandResult integrityCheckerCommandResult;
        int checksAmount = this.checks.size();
        this.log.debug((Object)String.format("Starting to run Integrity Checker operation %s with %d checks.", this.integrityCheckerOperation.getOperationName(), checksAmount));
        try {
            Context context = Contexts.builder().sized((Sized)new FixedSized(checksAmount)).progress(this.taskProgressSink, this.i18nHelper, "admin.integritychecker.operation.progress.percent.complete", null).log(this.log, "Integrity Checker operation is {0}% complete. Index of current item: {1}").build();
            context.setName("integrity checker operation");
            Map<Long, List<Amendment>> results = this.integrityCheckerOperation.perform(this.checks, context);
            integrityCheckerCommandResult = new IntegrityCheckerCommandResult(results, this.contextParameters, (ErrorCollection)new SimpleErrorCollection());
        }
        catch (IntegrityException e) {
            IntegrityCheckerCommandResult integrityCheckerCommandResult2;
            try {
                this.log.warn((Object)"Error while performing integrity checker operation", (Throwable)e);
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                errorCollection.addErrorMessage(this.i18nHelper.getText("admin.integritychecker.operation.perform.error"));
                integrityCheckerCommandResult2 = new IntegrityCheckerCommandResult(null, this.contextParameters, (ErrorCollection)errorCollection);
            }
            catch (Throwable throwable) {
                this.log.debug((Object)String.format("Integrity Checker operation %s finished for %d checks.", this.integrityCheckerOperation.getOperationName(), checksAmount));
                throw throwable;
            }
            this.log.debug((Object)String.format("Integrity Checker operation %s finished for %d checks.", this.integrityCheckerOperation.getOperationName(), checksAmount));
            return integrityCheckerCommandResult2;
        }
        this.log.debug((Object)String.format("Integrity Checker operation %s finished for %d checks.", this.integrityCheckerOperation.getOperationName(), checksAmount));
        return integrityCheckerCommandResult;
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }
}

