/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleAdminService;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultApplicationRoleAdminService
implements ApplicationRoleAdminService {
    private final GroupManager groupManager;
    private final ApplicationRoleManager applicationRoleManager;
    private final JiraAuthenticationContext ctx;
    private final GlobalPermissionManager permissionManager;

    public DefaultApplicationRoleAdminService(@Nonnull GroupManager groupManager, @Nonnull ApplicationRoleManager applicationRoleManager, @Nonnull JiraAuthenticationContext ctx, @Nonnull GlobalPermissionManager permissionManager) {
        this.ctx = (JiraAuthenticationContext)Assertions.notNull((String)"ctx", (Object)ctx);
        this.permissionManager = (GlobalPermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.groupManager = (GroupManager)Assertions.notNull((String)"groupManager", (Object)groupManager);
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
    }

    @Nonnull
    public ServiceOutcome<Set<ApplicationRole>> getRoles() {
        ServiceOutcome outcome = this.validatePermission();
        if (!outcome.isValid()) {
            return outcome;
        }
        return ServiceOutcomeImpl.ok(this.applicationRoleManager.getRoles());
    }

    @Nonnull
    public ServiceOutcome<ApplicationRole> getRole(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        ServiceOutcome outcome = this.validatePermission();
        if (!outcome.isValid()) {
            return outcome;
        }
        Option roleOption = this.applicationRoleManager.getRole(key);
        if (roleOption.isDefined()) {
            return ServiceOutcomeImpl.ok((ApplicationRole)roleOption.get());
        }
        return this.generateNotFoundOutcomeFor(key);
    }

    @Nonnull
    public ServiceOutcome<ApplicationRole> setRole(@Nonnull ApplicationRole role) {
        Assertions.notNull((String)"role", (Object)role);
        ServiceOutcome outcome = this.validatePermission();
        if (!outcome.isValid()) {
            return outcome;
        }
        if (!this.applicationRoleManager.getRole(role.getKey()).isDefined()) {
            return this.generateNotFoundOutcomeFor(role.getKey());
        }
        outcome = this.validateGroups(role);
        if (!outcome.isValid()) {
            return outcome;
        }
        return ServiceOutcomeImpl.ok(this.applicationRoleManager.setRole(role));
    }

    @Nonnull
    public ServiceOutcome<Set<ApplicationRole>> setRoles(@Nonnull Collection<ApplicationRole> roles) {
        Assertions.notNull((String)"roles", roles);
        ServiceOutcome outcome = this.validatePermission();
        if (!outcome.isValid()) {
            return outcome;
        }
        HashSet<ApplicationRole> appRoles = new HashSet<ApplicationRole>();
        for (ApplicationRole role : roles) {
            if (!this.applicationRoleManager.getRole(role.getKey()).isDefined()) {
                return this.generateNotFoundOutcomeFor(role.getKey());
            }
            outcome = this.validateGroups(role);
            if (!outcome.isValid()) {
                return outcome;
            }
            appRoles.add(this.applicationRoleManager.setRole(role));
        }
        return ServiceOutcomeImpl.ok(appRoles);
    }

    private <T> ServiceOutcome<T> validatePermission() {
        if (!this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.ctx.getLoggedInUser())) {
            return ServiceOutcomeImpl.error(this.ctx.getI18nHelper().getText("application.role.service.permission.denied"), ErrorCollection.Reason.FORBIDDEN);
        }
        return ServiceOutcomeImpl.ok(null);
    }

    private <T> ServiceOutcome<T> validateGroups(ApplicationRole role) {
        for (Group group : role.getGroups()) {
            if (this.groupManager.groupExists(group)) continue;
            return this.generateErrorOutcomeFor("groups", this.ctx.getI18nHelper().getText("application.role.service.group.does.not.exist", group.getName()));
        }
        return ServiceOutcomeImpl.ok(null);
    }

    private <T> ServiceOutcome<T> generateErrorOutcomeFor(String key, String message) {
        SimpleErrorCollection collection = new SimpleErrorCollection();
        collection.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
        collection.addError(key, message);
        return new ServiceOutcomeImpl((ErrorCollection)collection);
    }

    private <T> ServiceOutcome<T> generateNotFoundOutcomeFor(ApplicationKey key) {
        String message = this.ctx.getI18nHelper().getText("application.role.service.role.does.not.exist", key.value());
        return ServiceOutcomeImpl.error(message, ErrorCollection.Reason.NOT_FOUND);
    }
}

