/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.host.plugin.PluginApplicationMetaData;
import com.atlassian.application.host.plugin.PluginApplicationMetaDataManager;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleDefinitions;
import com.atlassian.jira.application.UndefinedApplicationRoleName;
import com.atlassian.jira.license.JiraLicenseManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultApplicationRoleDefinitions
implements ApplicationRoleDefinitions {
    private final JiraLicenseManager licenseManager;
    private final PluginApplicationMetaDataManager metaDataManager;

    public DefaultApplicationRoleDefinitions(JiraLicenseManager licenseManager, PluginApplicationMetaDataManager metaDataManager) {
        this.metaDataManager = metaDataManager;
        this.licenseManager = licenseManager;
    }

    @Override
    @Nonnull
    public Iterable<ApplicationRoleDefinitions.ApplicationRoleDefinition> getDefined() {
        return Iterables.concat(this.getPlatformRoles(), this.getPluginRoles());
    }

    @Override
    @Nonnull
    public Option<ApplicationRoleDefinitions.ApplicationRoleDefinition> getDefined(ApplicationKey applicationKey) {
        return io.atlassian.fugue.Iterables.findFirst(this.getDefined(), def -> def != null && def.key().equals((Object)applicationKey));
    }

    @Override
    public boolean isDefined(ApplicationKey applicationKey) {
        return this.getDefined(applicationKey).isDefined();
    }

    @Override
    @Nonnull
    public Iterable<ApplicationRoleDefinitions.ApplicationRoleDefinition> getLicensed() {
        HashSet licensedAppRoleDefinitions = Sets.newHashSet();
        Set allLicensedApplicationKeys = this.licenseManager.getAllLicensedApplicationKeys();
        if (allLicensedApplicationKeys.isEmpty()) {
            return Option.none();
        }
        for (ApplicationKey key : allLicensedApplicationKeys) {
            licensedAppRoleDefinitions.add(this.getIfDefinedOrCreateUnDefined(key));
        }
        return licensedAppRoleDefinitions;
    }

    private ApplicationRoleDefinitions.ApplicationRoleDefinition getIfDefinedOrCreateUnDefined(ApplicationKey key) {
        Option<ApplicationRoleDefinitions.ApplicationRoleDefinition> applicationRoleDefinitions = this.getDefined(key);
        if (applicationRoleDefinitions.isDefined()) {
            return (ApplicationRoleDefinitions.ApplicationRoleDefinition)applicationRoleDefinitions.get();
        }
        return new UnDefinedApplicationRoleDefinition(key);
    }

    @Override
    public Option<ApplicationRoleDefinitions.ApplicationRoleDefinition> getLicensed(ApplicationKey key) {
        if (!this.licenseManager.getAllLicensedApplicationKeys().contains(key)) {
            return Option.none();
        }
        return Option.some((Object)this.getIfDefinedOrCreateUnDefined(key));
    }

    @Override
    public boolean isLicensed(ApplicationKey key) {
        return this.getLicensed(key).isDefined();
    }

    private Iterable<PluginApplicationRoleDefinition> getPluginRoles() {
        return Iterables.transform((Iterable)this.metaDataManager.getApplications(), PluginApplicationRoleDefinition::new);
    }

    private Iterable<CoreRoleDefinition> getPlatformRoles() {
        return Collections.singleton(CoreRoleDefinition.INSTANCE);
    }

    private static class UnDefinedApplicationRoleDefinition
    implements ApplicationRoleDefinitions.ApplicationRoleDefinition {
        private final ApplicationKey applicationKey;
        private final String name;

        private UnDefinedApplicationRoleDefinition(ApplicationKey applicationKey) {
            this.applicationKey = applicationKey;
            this.name = UndefinedApplicationRoleName.of(applicationKey).getName();
        }

        @Override
        public ApplicationKey key() {
            return this.applicationKey;
        }

        @Override
        public String name() {
            return this.name;
        }
    }

    static class CoreRoleDefinition
    implements ApplicationRoleDefinitions.ApplicationRoleDefinition {
        static final CoreRoleDefinition INSTANCE = new CoreRoleDefinition();

        private CoreRoleDefinition() {
        }

        @Override
        public ApplicationKey key() {
            return ApplicationKeys.CORE;
        }

        @Override
        public String name() {
            return "Jira Core";
        }
    }

    private static class PluginApplicationRoleDefinition
    implements ApplicationRoleDefinitions.ApplicationRoleDefinition {
        private final PluginApplicationMetaData metaData;

        private PluginApplicationRoleDefinition(PluginApplicationMetaData metaData) {
            this.metaData = metaData;
        }

        @Override
        public ApplicationKey key() {
            return this.metaData.getKey();
        }

        @Override
        public String name() {
            return this.metaData.getName();
        }
    }
}

