/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.sal.api.user.UserKey;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.net.URI;
import javax.annotation.Nullable;

class JiraApplicationAccess
implements ApplicationAccess {
    static final String URL_USER_BROWSER_BTF = "/secure/admin/user/UserBrowser.jspa?applicationFilter=%s";
    private final ApplicationRole role;
    private final ApplicationAuthorizationService authorizationService;
    private final UserManager userManager;

    JiraApplicationAccess(ApplicationRole role, ApplicationAuthorizationService authorizationService, UserManager userManager) {
        this.role = (ApplicationRole)Assertions.notNull((String)"role", (Object)role);
        this.authorizationService = (ApplicationAuthorizationService)Assertions.notNull((String)"authorizationService", (Object)authorizationService);
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
    }

    public ApplicationKey getApplicationKey() {
        return this.role.getKey();
    }

    public Option<Integer> getMaximumUserCount() {
        int seats = this.role.getNumberOfSeats();
        if (seats == -1) {
            return Option.none();
        }
        return Option.some((Object)seats);
    }

    public int getActiveUserCount() {
        return this.authorizationService.getUserCount(this.role.getKey());
    }

    public boolean canUserAccessApplication(@Nullable UserKey userKey) {
        return this.authorizationService.canUseApplication(this.getApplicationUserFromKey(userKey), this.role.getKey());
    }

    public Option<ApplicationAccess.AccessError> getAccessError(@Nullable UserKey userKey) {
        ApplicationUser user = this.getApplicationUserFromKey(userKey);
        ApplicationKey key = this.role.getKey();
        return Option.option((Object)((ApplicationAccess.AccessError)Iterables.first((Iterable)this.authorizationService.getAccessErrors(user, key)).getOrNull()));
    }

    private ApplicationUser getApplicationUserFromKey(@Nullable UserKey userKey) {
        if (userKey == null) {
            return null;
        }
        return this.userManager.getUserByKey(userKey.getStringValue());
    }

    public URI getManagementPage() {
        return JiraApplicationAccess.getManagementPageForRole(this.role.getKey());
    }

    public static URI getManagementPageForRole(ApplicationKey key) {
        return URI.create(String.format(URL_USER_BROWSER_BTF, key.value()));
    }
}

