/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.application.ApplicationRoleStore;
import com.atlassian.jira.config.group.GroupConfigurable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

public class OfBizApplicationRoleStore
implements ApplicationRoleStore,
GroupConfigurable {
    private static final String ENTITY_LICENSE_ROLE_GROUP = "LicenseRoleGroup";
    private static final String ENTITY_LICENSE_ROLE_DEFAULT = "LicenseRoleDefault";
    private final OfBizDelegator delegator;

    public OfBizApplicationRoleStore(@Nonnull OfBizDelegator delegator) {
        this.delegator = (OfBizDelegator)Assertions.notNull((String)"delegator", (Object)delegator);
    }

    @Override
    @Nonnull
    public ApplicationRoleStore.ApplicationRoleData get(@Nonnull ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        String appKey = OfBizApplicationRoleStore.toStringKey(key);
        List<GenericValue> entries = this.getById(appKey);
        HashSet groups = Sets.newHashSetWithExpectedSize((int)entries.size());
        HashSet<String> defaultGroups = new HashSet<String>();
        for (GenericValue entry : entries) {
            String groupKey = OfBizApplicationRoleStore.toGroupKey(entry.getString("groupId"));
            groups.add(groupKey);
            if (!this.isDefault(entry)) continue;
            defaultGroups.add(groupKey);
        }
        return new ApplicationRoleStore.ApplicationRoleData(key, groups, defaultGroups, this.isSelectedByDefault(appKey));
    }

    @Override
    @Nonnull
    public ApplicationRoleStore.ApplicationRoleData save(@Nonnull ApplicationRoleStore.ApplicationRoleData data) {
        Assertions.notNull((String)"data", (Object)data);
        String applicationRoleKey = OfBizApplicationRoleStore.toStringKey(data.getKey());
        Set<String> newDefaults = OfBizApplicationRoleStore.toGroupKeys(data.getDefaultGroups());
        Set<String> newGroups = OfBizApplicationRoleStore.toGroupKeys(data.getGroups());
        for (GenericValue entry : this.getById(applicationRoleKey)) {
            String currentGroupName = entry.getString("groupId");
            if (newGroups.remove(currentGroupName)) {
                if (this.isDefault(entry)) {
                    if (newDefaults.contains(currentGroupName)) continue;
                    entry.set("primaryGroup", (Object)false);
                    this.save(entry);
                    continue;
                }
                if (!newDefaults.contains(currentGroupName)) continue;
                entry.set("primaryGroup", (Object)true);
                this.save(entry);
                continue;
            }
            this.remove(entry);
        }
        for (String newGroup : newGroups) {
            this.delegator.createValue(ENTITY_LICENSE_ROLE_GROUP, (Map)ImmutableMap.of((Object)"licenseRoleName", (Object)applicationRoleKey, (Object)"groupId", (Object)newGroup, (Object)"primaryGroup", (Object)newDefaults.contains(newGroup)));
        }
        if (!data.isSelectedByDefault() && this.isSelectedByDefault(applicationRoleKey)) {
            this.delegator.removeByAnd(ENTITY_LICENSE_ROLE_DEFAULT, (Map)ImmutableMap.of((Object)"licenseRoleName", (Object)applicationRoleKey));
        } else if (data.isSelectedByDefault() && !this.isSelectedByDefault(applicationRoleKey)) {
            this.delegator.createValue(ENTITY_LICENSE_ROLE_DEFAULT, (Map)ImmutableMap.of((Object)"licenseRoleName", (Object)applicationRoleKey));
        }
        return this.get(data.getKey());
    }

    @Override
    public void removeGroup(@Nonnull String groupName) {
        String groupKey = OfBizApplicationRoleStore.toGroupKey(groupName);
        this.delegator.removeByAnd(ENTITY_LICENSE_ROLE_GROUP, (Map)ImmutableMap.of((Object)"groupId", (Object)groupKey));
    }

    @Override
    public void removeByKey(@Nonnull ApplicationKey applicationKey) {
        this.delegator.removeByAnd(ENTITY_LICENSE_ROLE_GROUP, (Map)ImmutableMap.of((Object)"licenseRoleName", (Object)OfBizApplicationRoleStore.toStringKey(applicationKey)));
        this.delegator.removeByAnd(ENTITY_LICENSE_ROLE_DEFAULT, (Map)ImmutableMap.of((Object)"licenseRoleName", (Object)OfBizApplicationRoleStore.toStringKey(applicationKey)));
    }

    private boolean isSelectedByDefault(String licenseRoleName) {
        return !this.delegator.findByAnd(ENTITY_LICENSE_ROLE_DEFAULT, (Map)ImmutableMap.of((Object)"licenseRoleName", (Object)licenseRoleName)).isEmpty();
    }

    private void save(GenericValue entry) {
        this.delegator.store(entry);
    }

    private void remove(GenericValue entry) {
        this.delegator.removeValue(entry);
    }

    private List<GenericValue> getById(String key) {
        return this.delegator.findByAnd(ENTITY_LICENSE_ROLE_GROUP, (Map)ImmutableMap.of((Object)"licenseRoleName", (Object)key));
    }

    private static String toStringKey(ApplicationKey key) {
        return CaseFolding.foldString((String)key.value());
    }

    private static Set<String> toGroupKeys(Collection<String> groups) {
        return groups.stream().map(OfBizApplicationRoleStore::toGroupKey).collect(Collectors.toSet());
    }

    private static String toGroupKey(String group) {
        return IdentifierUtils.toLowerCase((String)group);
    }

    private boolean isDefault(GenericValue value) {
        return Boolean.TRUE.equals(value.getBoolean("primaryGroup"));
    }

    @Override
    public boolean isGroupUsed(@Nonnull Group group) {
        return !this.delegator.findByAnd(ENTITY_LICENSE_ROLE_GROUP, (Map)ImmutableMap.of((Object)"groupId", (Object)OfBizApplicationRoleStore.toGroupKey(group.getName()))).isEmpty();
    }

    private static class GroupColumns {
        private static final String NAME = "licenseRoleName";
        private static final String GROUP_ID = "groupId";
        private static final String DEFAULT = "primaryGroup";

        private GroupColumns() {
        }
    }

    private static class DefaultColumns {
        private static final String NAME = "licenseRoleName";

        private DefaultColumns() {
        }
    }
}

