/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.license.LicenseDetails;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AffectedLicense
implements AssociatedItem {
    public static final String TYPE_LICENSE = "License SEN";
    public static final String TYPE_EVALUATION_LICENSE = "Accepted Evaluation";
    private static final String DUMMY_ID = "0";
    private final String objectName;
    private final String licenseType;

    public AffectedLicense(@Nonnull LicenseDetails license) {
        this(license.getSupportEntitlementNumber(), false);
    }

    public AffectedLicense(String objectName, @Nonnull Boolean isEvaluation) {
        this.objectName = objectName == null ? "<SEN N/A>" : objectName;
        this.licenseType = isEvaluation != false ? TYPE_EVALUATION_LICENSE : TYPE_LICENSE;
    }

    @Override
    @Nonnull
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public String getObjectId() {
        return DUMMY_ID;
    }

    @Override
    @Nullable
    public String getParentName() {
        return this.licenseType;
    }

    @Override
    @Nullable
    public String getParentId() {
        return DUMMY_ID;
    }

    @Override
    @Nonnull
    public AssociatedItem.Type getObjectType() {
        return AssociatedItem.Type.LICENSE;
    }
}

