/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class AssociatedItemImpl
implements AssociatedItem {
    public static final String OBJECT_TYPE = "objectType";
    public static final String OBJECT_ID = "objectId";
    public static final String OBJECT_NAME = "objectName";
    public static final String OBJECT_PARENT_ID = "objectParentId";
    public static final String OBJECT_PARENT_NAME = "objectParentName";
    protected final GenericValue gv;

    public AssociatedItemImpl(GenericValue gv) {
        this.gv = gv;
    }

    public static Function<? super GenericValue, AssociatedItem> from() {
        return new Function<GenericValue, AssociatedItem>(){

            public AssociatedItem apply(GenericValue input) {
                return new AssociatedItemImpl(input);
            }
        };
    }

    @Override
    @Nonnull
    public String getObjectName() {
        return this.gv.getString(OBJECT_NAME);
    }

    @Override
    @Nullable
    public String getObjectId() {
        return this.gv.getString(OBJECT_ID);
    }

    @Override
    @Nullable
    public String getParentName() {
        return this.gv.getString(OBJECT_PARENT_NAME);
    }

    @Override
    @Nullable
    public String getParentId() {
        return this.gv.getString(OBJECT_PARENT_ID);
    }

    @Override
    @Nonnull
    public AssociatedItem.Type getObjectType() {
        return AssociatedItem.Type.valueOf(this.gv.getString(OBJECT_TYPE));
    }
}

