/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AssociatedItemImpl;
import com.atlassian.jira.auditing.AuditRecord;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class AuditRecordImpl
implements AuditRecord {
    public static final String ID = "id";
    public static final String AUTHOR_KEY = "authorKey";
    public static final String REMOTE_ADDR = "remoteAddress";
    public static final String CATEGORY = "category";
    public static final String CREATED = "created";
    public static final String SUMMARY = "summary";
    public static final String OBJECT_TYPE = "objectType";
    public static final String OBJECT_NAME = "objectName";
    public static final String OBJECT_PARENT_ID = "objectParentId";
    public static final String OBJECT_PARENT_NAME = "objectParentName";
    public static final String OBJECT_ID = "objectId";
    public static final String AUTHOR_TYPE = "authorType";
    public static final String EVENT_SOURCE = "eventSourceName";
    public static final String LONG_DESCRIPTION = "longDescription";
    public static final String SEARCH_FIELD = "searchField";
    @Deprecated
    public static final String OLD_DESCRIPTION = "description";
    protected final GenericValue gv;
    protected final ImmutableList<AssociatedItem> associatedItems;
    protected final ImmutableList<ChangedValue> changedValues;

    public AuditRecordImpl(GenericValue gv, Iterable<AssociatedItem> associatedItems, Iterable<ChangedValue> changedValues) {
        this.gv = gv;
        this.associatedItems = ImmutableList.copyOf(associatedItems);
        this.changedValues = ImmutableList.copyOf(changedValues);
    }

    @Override
    @Nonnull
    public Long getId() {
        return this.gv.getLong(ID);
    }

    @Override
    @Nullable
    public String getAuthorKey() {
        return this.gv.getString(AUTHOR_KEY);
    }

    @Override
    @Nullable
    public String getRemoteAddr() {
        return this.gv.getString(REMOTE_ADDR);
    }

    @Override
    @Nonnull
    public Date getCreated() {
        return this.gv.getTimestamp(CREATED);
    }

    @Override
    @Nonnull
    public AuditingCategory getCategory() {
        return AuditingCategory.getCategoryById(this.gv.getString(CATEGORY));
    }

    @Override
    @Nonnull
    public String getSummary() {
        return this.gv.getString(SUMMARY);
    }

    @Override
    @Nonnull
    public String getEventSource() {
        return this.gv.getString(EVENT_SOURCE);
    }

    @Override
    @Nullable
    public String getDescription() {
        String description = this.gv.getString(LONG_DESCRIPTION);
        if (!StringUtils.isBlank((CharSequence)description)) {
            return description;
        }
        return this.gv.getString(OLD_DESCRIPTION);
    }

    @Override
    @Nonnull
    public Iterable<AssociatedItem> getAssociatedItems() {
        return this.associatedItems;
    }

    @Override
    @Nonnull
    public Iterable<ChangedValue> getValues() {
        return this.changedValues;
    }

    @Override
    @Nullable
    public AssociatedItem getObjectItem() {
        if (this.gv.getString(OBJECT_NAME) != null && this.gv.getString(OBJECT_TYPE) != null) {
            return new AssociatedItemImpl(this.gv);
        }
        return null;
    }
}

