/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.AuditingFilter;
import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.auditing.AuditingService;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.Records;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DefaultAuditingService
implements AuditingService {
    public static final Integer MAX_LEN = 255;
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final AuditingManager auditingManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PluginAccessor pluginAccessor;

    public DefaultAuditingService(PermissionManager permissionManager, I18nHelper.BeanFactory i18nFactory, AuditingManager auditingManager, JiraAuthenticationContext jiraAuthenticationContext, PluginAccessor pluginAccessor) {
        this.permissionManager = permissionManager;
        this.i18nFactory = i18nFactory;
        this.auditingManager = auditingManager;
        this.authenticationContext = jiraAuthenticationContext;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    @Nonnull
    public ServiceOutcome<Records> getRecords(@Nullable Integer offset, @Nullable Integer maxResults, @Nullable AuditingFilter filter) {
        ApplicationUser user = this.authenticationContext.getUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nFactory = this.i18nFactory.getInstance(user);
        if (user == null || !this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nFactory.getText("jira.auditing.service.no.admin.permission"), ErrorCollection.Reason.FORBIDDEN);
            return new ServiceOutcomeImpl<Object>((ErrorCollection)errorCollection, null);
        }
        Records records = this.auditingManager.getRecords(null, null, maxResults, offset, filter);
        return new ServiceOutcomeImpl<Records>((ErrorCollection)errorCollection, records);
    }

    @Override
    @Nonnull
    public ErrorCollection storeRecord(@Nullable String category, @Nullable String summary, @Nonnull String eventSourceKey, @Nullable AssociatedItem objectItem, @Nullable Iterable<ChangedValue> changedValues, @Nullable Iterable<AssociatedItem> associatedItems, @Nullable String description) {
        ApplicationUser user = this.authenticationContext.getUser();
        I18nHelper i18nBean = this.i18nFactory.getInstance(user);
        if (StringUtils.isEmpty((CharSequence)eventSourceKey)) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessage(i18nBean.getText("jira.auditing.service.event.source.not.empty"));
            return errorCollection;
        }
        Plugin plugin = this.pluginAccessor.getPlugin(eventSourceKey);
        if (plugin == null) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessage(i18nBean.getText("jira.auditing.service.event.plugin.not.found", eventSourceKey));
            return errorCollection;
        }
        return this.storeRecordData(category, summary, plugin.getName(), objectItem, changedValues, associatedItems, description);
    }

    @Override
    @Nonnull
    public ErrorCollection storeRecord(@Nonnull String category, @Nonnull String summary, @Nullable AssociatedItem objectItem, @Nullable Iterable<ChangedValue> changedValues, @Nullable Iterable<AssociatedItem> associatedItems, String description) {
        return this.storeRecordData(category, summary, "", objectItem, changedValues, associatedItems, description);
    }

    @Override
    @Nonnull
    public ErrorCollection storeRecord(@Nonnull String category, @Nonnull String summary, @Nullable AssociatedItem objectItem, @Nullable Iterable<ChangedValue> changedValues, @Nullable Iterable<AssociatedItem> associatedItems) {
        return this.storeRecordData(category, summary, "", objectItem, changedValues, associatedItems, null);
    }

    @Override
    @Nonnull
    public ErrorCollection storeRecord(@Nullable String category, @Nullable String summary, @Nonnull String eventSourceKey, @Nullable AssociatedItem objectItem, @Nullable Iterable<ChangedValue> changedValues, @Nullable Iterable<AssociatedItem> associatedItems) {
        return this.storeRecord(category, summary, eventSourceKey, objectItem, changedValues, associatedItems, null);
    }

    @Override
    @Nonnull
    public Long getTotalNumberOfRecords() {
        return this.auditingManager.countRecords(null, null);
    }

    protected void validateCategoryAndSummary(String category, String summary, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (StringUtils.isBlank((CharSequence)summary)) {
            errorCollection.addError("summary", i18nBean.getText("jira.auditing.service.field.must.be.set", "summary"));
        } else if (summary.length() > MAX_LEN) {
            errorCollection.addError("summary", i18nBean.getText("createissue.error.summary.less.than", MAX_LEN.toString()));
        }
        if (StringUtils.isBlank((CharSequence)category)) {
            errorCollection.addError("category", i18nBean.getText("jira.auditing.service.field.must.be.set", "category"));
        } else if (AuditingCategory.getCategoryByIdOrName(category) == null) {
            errorCollection.addError("category", i18nBean.getText("jira.auditing.service.invalid.category", category));
        }
    }

    protected void validateChangedValues(@Nonnull String fieldId, @Nonnull Iterable<ChangedValue> values, @Nonnull ErrorCollection errorCollection, @Nonnull I18nHelper i18nBean) {
        int idx = 0;
        for (ChangedValue value : values) {
            this.validateChangedValue(fieldId + "[" + idx++ + "]", value, errorCollection, i18nBean);
        }
    }

    protected void validateChangedValue(@Nonnull String fieldId, @Nonnull ChangedValue value, @Nonnull ErrorCollection errorCollection, @Nonnull I18nHelper i18nBean) {
        if (StringUtils.isBlank((CharSequence)value.getName())) {
            errorCollection.addError(fieldId, i18nBean.getText("jira.auditing.service.field.must.be.set", "name"));
        }
    }

    protected void validateAssociatedItems(@Nonnull String fieldId, @Nonnull Iterable<AssociatedItem> associatedItems, @Nonnull ErrorCollection errorCollection, @Nonnull I18nHelper i18nBean) {
        int idx = 0;
        for (AssociatedItem associatedItem : associatedItems) {
            this.validateAssociatedItem(fieldId + "[" + idx++ + "]", associatedItem, errorCollection, i18nBean);
        }
    }

    protected void validateAssociatedItem(@Nonnull String fieldId, @Nonnull AssociatedItem objectItem, @Nonnull ErrorCollection errorCollection, @Nonnull I18nHelper i18nBean) {
        if (StringUtils.isBlank((CharSequence)objectItem.getObjectName())) {
            errorCollection.addError(fieldId, i18nBean.getText("jira.auditing.service.field.must.be.set", "name"));
        }
        if (AssociatedItem.Type.PROJECT.equals((Object)objectItem.getObjectType()) && StringUtils.isBlank((CharSequence)objectItem.getObjectId())) {
            errorCollection.addError(fieldId, i18nBean.getText("jira.auditing.service.field.must.be.set", "id"));
        }
        if (objectItem.getObjectType() == AssociatedItem.Type.UNSPECIFIED) {
            errorCollection.addError(fieldId, i18nBean.getText("jira.auditing.service.internal.usage.of.unspecified", "UNSPECIFIED"));
        }
    }

    private ErrorCollection storeRecordData(String category, String summary, String eventSourceName, AssociatedItem objectItem, Iterable<ChangedValue> changedValues, Iterable<AssociatedItem> associatedItems, String description) {
        ApplicationUser user = this.authenticationContext.getUser();
        I18nHelper i18nBean = this.i18nFactory.getInstance(user);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (user == null || !this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("jira.auditing.service.no.admin.permission"));
            return errorCollection;
        }
        String trimmedSummary = StringUtils.trimToEmpty((String)summary);
        this.validateCategoryAndSummary(category, trimmedSummary, (ErrorCollection)errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            return errorCollection;
        }
        String trimmedEventSource = StringUtils.trimToEmpty((String)eventSourceName);
        RecordRequest record = new RecordRequest(AuditingCategory.getCategoryByIdOrName(category), trimmedSummary, trimmedEventSource).withActionI18nKey(trimmedSummary);
        if (objectItem != null) {
            this.validateAssociatedItem("objectItem", objectItem, (ErrorCollection)errorCollection, i18nBean);
            record.forObject(objectItem);
        }
        if (changedValues != null) {
            this.validateChangedValues("changedValues", changedValues, (ErrorCollection)errorCollection, i18nBean);
            record.withChangedValues(changedValues);
        }
        if (associatedItems != null) {
            this.validateAssociatedItems("associatedItems", associatedItems, (ErrorCollection)errorCollection, i18nBean);
            record.withAssociatedItems(associatedItems);
        }
        if (description != null) {
            record.withDescription(description);
        }
        if (!errorCollection.hasAnyErrors()) {
            this.auditingManager.store(record);
        }
        return errorCollection;
    }
}

