/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.converters;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditRecord;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.ChangedValueImpl;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AuditRecords {
    public static AuditRecord from(final AuditEntity auditEntity) {
        final List associatedItems = auditEntity.getAffectedObjects().stream().map(resource -> new RecordRequest.AssociatedItemImpl(resource.getName(), resource.getId(), AuditRecords.getTypeFrom(resource.getType()))).filter(associatedItem -> associatedItem.getObjectType() != null).collect(Collectors.toList());
        return new AuditRecord(){

            @Override
            @Nonnull
            public Long getId() {
                return auditEntity.getId();
            }

            @Override
            @Nonnull
            public Date getCreated() {
                return Date.from(auditEntity.getTimestamp());
            }

            @Override
            @Nonnull
            public AuditingCategory getCategory() {
                return AuditingCategory.getCategoryByNameI18nKeyWithFallback(auditEntity.getAuditType().getCategoryI18nKey(), AuditingCategory.ECOSYSTEM);
            }

            @Override
            @Nonnull
            public String getSummary() {
                return auditEntity.getAuditType().getAction();
            }

            @Override
            @Nonnull
            public String getEventSource() {
                return auditEntity.getMethod();
            }

            @Override
            @Nullable
            public String getRemoteAddr() {
                return auditEntity.getSource();
            }

            @Override
            @Nullable
            public String getAuthorKey() {
                return AuditRecords.getKeyFromId(auditEntity.getAuthor().getId());
            }

            @Override
            @Nonnull
            public Iterable<AssociatedItem> getAssociatedItems() {
                if (associatedItems.size() > 1) {
                    return associatedItems.subList(1, associatedItems.size());
                }
                return Collections.emptyList();
            }

            @Override
            @Nonnull
            public Iterable<ChangedValue> getValues() {
                return auditEntity.getChangedValues().stream().map(changedValue -> new ChangedValueImpl(changedValue.getKey(), changedValue.getFrom(), changedValue.getTo())).collect(Collectors.toList());
            }

            @Override
            @Nullable
            public AssociatedItem getObjectItem() {
                return !associatedItems.isEmpty() ? (AssociatedItem)associatedItems.get(0) : null;
            }

            @Override
            @Nullable
            public String getDescription() {
                return AuditEntitiesUtils.getExtraAttributeByI18nKeyOrName(auditEntity, "jira.auditing.extra.parameters.event.description", "description").orElse(null);
            }
        };
    }

    private static AssociatedItem.Type getTypeFrom(String name) {
        return Arrays.stream(AssociatedItem.Type.values()).filter(type -> type.name().equals(name)).findFirst().orElse(null);
    }

    private static String getKeyFromId(String id) {
        return AuditRecords.getUserWithId(id).map(ApplicationUser::getKey).orElse(id);
    }

    private static Optional<ApplicationUser> getUserWithId(String id) {
        try {
            long userId = Long.parseLong(id);
            return ComponentAccessor.getUserManager().getUserById(Long.valueOf(userId));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

