/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.AttachmentHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nonnull;

@AuditExceptionSafe
public class AttachmentHandlerImpl
implements AttachmentHandler {
    private static final AuditType ISSUE_ATTACHMENT_ADDED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, "jira.auditing.category.issue", "jira.auditing.issue.attachment.added", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public AttachmentHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleAttachmentDeleted(@Nonnull Attachment attachment, @Nonnull Issue issue, @Nonnull ApplicationUser user) {
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUE_ATTACHMENT_ADDED).affectedObject(AuditResource.builder((String)issue.getKey(), (String)AssociatedItem.Type.ISSUE.name()).id(issue.getKey()).build()).changedValues(new ChangedValuesBuilder().add("issue.field.attachment", attachment.getFilename(), null).build()).build());
    }
}

