/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.CustomFieldContextHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

@AuditExceptionSafe
public class CustomFieldContextHandlerImpl
implements CustomFieldContextHandler {
    private static final AuditType CUSTOMFIELD_CONTEXT_ADDED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.fields", "jira.auditing.customfield.context.added", CoverageLevel.ADVANCED);
    private static final AuditType CUSTOMFIELD_CONTEXT_CHANGED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.fields", "jira.auditing.customfield.context.changed", CoverageLevel.ADVANCED);
    private static final AuditType CUSTOMFIELD_CONTEXT_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.fields", "jira.auditing.customfield.context.deleted", CoverageLevel.ADVANCED);
    private final AuditService auditService;
    private final String forAllIssuesTextValue;

    public CustomFieldContextHandlerImpl(AuditService auditService, I18nHelper.BeanFactory beanFactory) {
        this.auditService = auditService;
        this.forAllIssuesTextValue = beanFactory.getInstance(Locale.ENGLISH).getText("admin.issuefields.customfields.global.all.issues");
    }

    @Override
    @ThrowSafe
    public void handleCustomFieldContextAdded(FieldConfigScheme newScheme) {
        this.auditService.audit(AuditEvent.builder((AuditType)CUSTOMFIELD_CONTEXT_ADDED).affectedObject(AuditResource.builder((String)newScheme.getField().getName(), (String)AssociatedItem.Type.CUSTOM_FIELD.name()).id(newScheme.getField().getId()).build()).changedValues(new ChangedValuesBuilder().add("admin.issuefields.configuration.scheme.label", newScheme.getName()).add("common.words.description", newScheme.getDescription()).add("admin.issuefields.customfields.projects", this.getProjectsTextValue(newScheme)).add("admin.issuefields.customfields.issue.types", this.getIssueTypesTextValue(newScheme)).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleCustomFieldContextUpdated(FieldConfigScheme oldScheme, FieldConfigScheme newScheme) {
        this.auditService.audit(AuditEvent.builder((AuditType)CUSTOMFIELD_CONTEXT_CHANGED).affectedObject(AuditResource.builder((String)newScheme.getField().getName(), (String)AssociatedItem.Type.CUSTOM_FIELD.name()).id(newScheme.getField().getId()).build()).changedValues(new ChangedValuesBuilder().addIfDifferent("admin.issuefields.configuration.scheme.label", oldScheme.getName(), newScheme.getName()).addIfDifferent("common.words.description", oldScheme.getDescription(), newScheme.getDescription()).addIfDifferent("admin.issuefields.customfields.projects", this.getProjectsTextValue(oldScheme), this.getProjectsTextValue(newScheme)).addIfDifferent("admin.issuefields.customfields.issue.types", this.getIssueTypesTextValue(oldScheme), this.getIssueTypesTextValue(newScheme)).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleCustomFieldContextDeleted(FieldConfigScheme configScheme) {
        this.auditService.audit(AuditEvent.builder((AuditType)CUSTOMFIELD_CONTEXT_DELETED).affectedObject(AuditResource.builder((String)configScheme.getField().getName(), (String)AssociatedItem.Type.CUSTOM_FIELD.name()).id(configScheme.getField().getId()).build()).changedValues(new ChangedValuesBuilder().add("admin.issuefields.configuration.scheme.label", configScheme.getName(), null).add("common.words.description", configScheme.getDescription(), null).add("admin.issuefields.customfields.projects", this.getProjectsTextValue(configScheme), null).add("admin.issuefields.customfields.issue.types", this.getIssueTypesTextValue(configScheme), null).build()).build());
    }

    private String getProjectsTextValue(FieldConfigScheme configScheme) {
        if (configScheme.isAllProjects()) {
            return this.forAllIssuesTextValue;
        }
        return configScheme.getAssociatedProjectObjects().stream().filter(Objects::nonNull).map(Project::getName).collect(Collectors.joining(", "));
    }

    private String getIssueTypesTextValue(FieldConfigScheme configScheme) {
        if (configScheme.isAllIssueTypes()) {
            return this.forAllIssuesTextValue;
        }
        return configScheme.getAssociatedIssueTypes().stream().filter(Objects::nonNull).map(IssueConstant::getName).collect(Collectors.joining(", "));
    }
}

