/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.DetailedGeneralConfigurationChangesEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.config.properties.GeneralConfigurations;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;

@AuditExceptionSafe
public class DetailedGeneralConfigurationChangesEventHandlerImpl
implements DetailedGeneralConfigurationChangesEventHandler {
    @VisibleForTesting
    static final AuditType GENERAL_CONFIGURATION_CHANGED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.generalconfiguration", "jira.auditing.general.settings.changed", CoverageLevel.BASE);
    @VisibleForTesting
    static final String DISABLED = "common.concepts.disabled";
    @VisibleForTesting
    static final String ENABLED = "common.concepts.enabled";
    private final AuditService auditService;
    private final I18nHelper i18n;

    public DetailedGeneralConfigurationChangesEventHandlerImpl(AuditService auditService, I18nHelper i18n) {
        this.auditService = auditService;
        this.i18n = i18n;
    }

    @Override
    @ThrowSafe
    public void handleGeneralConfigurationUpdated(GeneralConfigurations oldConfiguration, GeneralConfigurations newConfiguration) {
        List<ChangedValue> changedValues = this.buildGeneralConfigurationChangedValues(oldConfiguration, newConfiguration);
        if (!changedValues.isEmpty()) {
            this.auditService.audit(AuditEvent.builder((AuditType)GENERAL_CONFIGURATION_CHANGED).changedValues(changedValues).build());
        }
    }

    public String getCommentVisibilityI18nString(Boolean commentVisibility) {
        return Boolean.TRUE.equals(commentVisibility) ? this.i18n.getText("admin.generalconfiguration.commentlevel.visibility.both") : this.i18n.getText("admin.generalconfiguration.commentlevel.visibility.rolesonly");
    }

    public String getEmailVisibilityI18nString(String emailVisibility) {
        switch (emailVisibility) {
            case "show": {
                return this.i18n.getText("admin.generalconfiguration.public");
            }
            case "mask": {
                return this.i18n.getText("jira.auditing.general.settings.changed.value.enable.email.header.masked");
            }
            case "user": {
                return this.i18n.getText("admin.generalconfiguration.logged.in.only");
            }
        }
        return this.i18n.getText("admin.generalconfiguration.hidden");
    }

    public String getIeMimeSnifferI18nString(String ieMimeSniffer) {
        switch (ieMimeSniffer) {
            case "insecure": {
                return this.i18n.getText("jira.auditing.general.settings.changed.value.ie.mime.sniffing.owned");
            }
            case "secure": {
                return this.i18n.getText("jira.auditing.general.settings.changed.value.ie.mime.sniffing.paranoid");
            }
        }
        return this.i18n.getText("jira.auditing.general.settings.changed.value.ie.mime.sniffing.workaround");
    }

    public String getIndexingLanguageI18nString(String indexingLanguage) {
        switch (indexingLanguage) {
            case "armenian": {
                return this.i18n.getText("admin.jira.allowed.language.armenian");
            }
            case "basque": {
                return this.i18n.getText("admin.jira.allowed.language.basque");
            }
            case "brazilian": {
                return this.i18n.getText("admin.jira.allowed.language.brazilian");
            }
            case "bulgarian": {
                return this.i18n.getText("admin.jira.allowed.language.bulgarian");
            }
            case "catalan": {
                return this.i18n.getText("admin.jira.allowed.language.catalan");
            }
            case "chinese": {
                return this.i18n.getText("admin.jira.allowed.language.chinese");
            }
            case "cjk": {
                return this.i18n.getText("admin.jira.allowed.language.cjk");
            }
            case "czech": {
                return this.i18n.getText("admin.jira.allowed.language.czech");
            }
            case "danish": {
                return this.i18n.getText("admin.jira.allowed.language.danish");
            }
            case "dutch": {
                return this.i18n.getText("admin.jira.allowed.language.dutch");
            }
            case "english": {
                return this.i18n.getText("admin.jira.allowed.language.english.aggressive.stemming");
            }
            case "english-moderate-stemming": {
                return this.i18n.getText("admin.jira.allowed.language.english.moderate.stemming");
            }
            case "english-minimal-stemming": {
                return this.i18n.getText("admin.jira.allowed.language.english.minimal.stemming");
            }
            case "finnish": {
                return this.i18n.getText("admin.jira.allowed.language.finnish");
            }
            case "french": {
                return this.i18n.getText("admin.jira.allowed.language.french");
            }
            case "german": {
                return this.i18n.getText("admin.jira.allowed.language.german");
            }
            case "greek": {
                return this.i18n.getText("admin.jira.allowed.language.greek");
            }
            case "hungarian": {
                return this.i18n.getText("admin.jira.allowed.language.hungarian");
            }
            case "italian": {
                return this.i18n.getText("admin.jira.allowed.language.italian");
            }
            case "norwegian": {
                return this.i18n.getText("admin.jira.allowed.language.norwegian");
            }
            case "portuguese": {
                return this.i18n.getText("admin.jira.allowed.language.portuguese");
            }
            case "romanian": {
                return this.i18n.getText("admin.jira.allowed.language.romanian");
            }
            case "russian": {
                return this.i18n.getText("admin.jira.allowed.language.russian");
            }
            case "spanish": {
                return this.i18n.getText("admin.jira.allowed.language.spanish");
            }
            case "swedish": {
                return this.i18n.getText("admin.jira.allowed.language.swedish");
            }
            case "thai": {
                return this.i18n.getText("admin.jira.allowed.language.thai");
            }
        }
        return this.i18n.getText("admin.jira.allowed.language.other");
    }

    public String getLogoutConfirmI18nString(String logoutConfirm) {
        switch (logoutConfirm) {
            case "always": {
                return this.i18n.getText("admin.common.words.always");
            }
            case "cookie": {
                return this.i18n.getText("admin.common.words.cookie");
            }
        }
        return this.i18n.getText("admin.common.words.never");
    }

    public String getModeI18nString(String mode) {
        return mode.equals("public") ? this.i18n.getText("admin.jira.mode.public") : this.i18n.getText("admin.jira.mode.private");
    }

    private List<ChangedValue> buildGeneralConfigurationChangedValues(GeneralConfigurations oldConfiguration, GeneralConfigurations newConfiguration) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("admin.common.words.title", oldConfiguration.getTitle(), newConfiguration.getTitle());
        changedValues.addIfDifferent("admin.common.words.mode", this.getModeI18nString(oldConfiguration.getMode()), this.getModeI18nString(newConfiguration.getMode()));
        changedValues.addIfDifferent("admin.generalconfiguration.maximum.authentication.attempts.allowed", oldConfiguration.getMaxAuthenticationAttempts(), newConfiguration.getMaxAuthenticationAttempts());
        changedValues.addIfDifferent("admin.generalconfiguration.captcha.on.signup", this.getBooleanPropertyValue(oldConfiguration.getCaptcha()), this.getBooleanPropertyValue(newConfiguration.getCaptcha()));
        changedValues.addIfDifferent("admin.generalconfiguration.base.url", oldConfiguration.getBaseUrl(), newConfiguration.getBaseUrl());
        changedValues.addIfDifferent("admin.generalconfiguration.email.from.header", oldConfiguration.getEmailFromHeaderFormat(), newConfiguration.getEmailFromHeaderFormat());
        changedValues.addIfDifferent("admin.common.words.introduction", oldConfiguration.getIntroduction(), newConfiguration.getIntroduction());
        changedValues.addIfDifferent("admin.generalconfiguration.indexing.language", this.getIndexingLanguageI18nString(oldConfiguration.getIndexingLanguage()), this.getIndexingLanguageI18nString(newConfiguration.getIndexingLanguage()));
        changedValues.addIfDifferent("admin.generalconfiguration.default.language", oldConfiguration.getDefaultLocale(), newConfiguration.getDefaultLocale());
        changedValues.addIfDifferent("admin.generalconfiguration.default.timezone", oldConfiguration.getDefaultTimezone(), newConfiguration.getDefaultTimezone());
        changedValues.addIfDifferent("admin.generalconfiguration.voting", this.getBooleanPropertyValue(oldConfiguration.getVote()), this.getBooleanPropertyValue(newConfiguration.getVote()));
        changedValues.addIfDifferent("admin.generalconfiguration.allow.users.to.watch", this.getBooleanPropertyValue(oldConfiguration.getWatch()), this.getBooleanPropertyValue(newConfiguration.getWatch()));
        changedValues.addIfDifferent("admin.generalconfiguration.allow.public.sharing", this.getBooleanPropertyValue(oldConfiguration.getGlobalSharing()), this.getBooleanPropertyValue(newConfiguration.getGlobalSharing()));
        changedValues.addIfDifferent("admin.generalconfiguration.maximum.length.project.names", oldConfiguration.getMaximumLengthProjectNames(), newConfiguration.getMaximumLengthProjectNames());
        changedValues.addIfDifferent("admin.generalconfiguration.maximum.length.project.keys", oldConfiguration.getMaximumLengthProjectKeys(), newConfiguration.getMaximumLengthProjectKeys());
        changedValues.addIfDifferent("admin.generalconfiguration.allow.unassigned.issues", this.getBooleanPropertyValue(oldConfiguration.getAllowUnassigned()), this.getBooleanPropertyValue(newConfiguration.getAllowUnassigned()));
        changedValues.addIfDifferent("admin.generalconfiguration.external.user.management", this.getBooleanPropertyValue(oldConfiguration.getExternalUserManagement()), this.getBooleanPropertyValue(newConfiguration.getExternalUserManagement()));
        changedValues.addIfDifferent("admin.generalconfiguration.logout.confirmation", this.getLogoutConfirmI18nString(oldConfiguration.getLogoutConfirm()), this.getLogoutConfirmI18nString(newConfiguration.getLogoutConfirm()));
        changedValues.addIfDifferent("admin.generalconfiguration.use.gzip.compression", this.getBooleanPropertyValue(oldConfiguration.getUseGZip()), this.getBooleanPropertyValue(newConfiguration.getUseGZip()));
        changedValues.addIfDifferent("admin.generalconfiguration.user.email.visibility", this.getEmailVisibilityI18nString(oldConfiguration.getEmailVisibility()), this.getEmailVisibilityI18nString(newConfiguration.getEmailVisibility()));
        changedValues.addIfDifferent("admin.generalconfiguration.commentlevel.visibility", this.getCommentVisibilityI18nString(oldConfiguration.getCommentVisibility()), this.getCommentVisibilityI18nString(newConfiguration.getCommentVisibility()));
        changedValues.addIfDifferent("jira.auditing.general.configuration.extra.attribute.key.enable.email.header", this.getBooleanPropertyValue(oldConfiguration.getExcludePrecedenceHeader()), this.getBooleanPropertyValue(newConfiguration.getExcludePrecedenceHeader()));
        changedValues.addIfDifferent("admin.generalconfiguration.enable.ajax.issue.picker", this.getBooleanPropertyValue(oldConfiguration.getIssuePicker()), this.getBooleanPropertyValue(newConfiguration.getIssuePicker()));
        changedValues.addIfDifferent("admin.generalconfiguration.enabled.jql.autocomplete", this.getBooleanPropertyValue(oldConfiguration.getJqlAutocomplete()), this.getBooleanPropertyValue(newConfiguration.getJqlAutocomplete()));
        changedValues.addIfDifferent("admin.generalconfiguration.ie.mime.sniffing", this.getIeMimeSnifferI18nString(oldConfiguration.getIeMimeSniffer()), this.getIeMimeSnifferI18nString(newConfiguration.getIeMimeSniffer()));
        changedValues.addIfDifferent("admin.generalconfiguration.show.contact.administrators.form", this.getBooleanPropertyValue(oldConfiguration.getShowContactAdministratorsForm()), this.getBooleanPropertyValue(newConfiguration.getShowContactAdministratorsForm()));
        changedValues.addIfDifferent("admin.generalconfiguration.contact.administrators.message", oldConfiguration.getContactAdministratorsMessage(), newConfiguration.getContactAdministratorsMessage());
        changedValues.addIfDifferent("admin.generalconfiguration.inline.edit", this.getBooleanPropertyValue(oldConfiguration.getInlineEdit()), this.getBooleanPropertyValue(newConfiguration.getInlineEdit()));
        changedValues.addIfDifferent("jira.issuenav.criteria.update.label", this.getBooleanPropertyValue(oldConfiguration.getCriteriaAutoUpdate()), this.getBooleanPropertyValue(newConfiguration.getCriteriaAutoUpdate()));
        changedValues.addIfDifferent("admin.generalconfiguration.project.description.html.enabled.label", this.getBooleanPropertyValue(oldConfiguration.getProjectDescriptionHtmlEnabled()), this.getBooleanPropertyValue(newConfiguration.getProjectDescriptionHtmlEnabled()));
        changedValues.addIfDifferent("admin.generalconfiguration.custom.field.html.enabled.label", this.getBooleanPropertyValue(oldConfiguration.getCustomFieldHtmlEnabled()), this.getBooleanPropertyValue(newConfiguration.getCustomFieldHtmlEnabled()));
        changedValues.addIfDifferent("admin.generalconfiguration.empty.jql.returns.no.data.label", this.getBooleanPropertyValue(oldConfiguration.getEmptyJqlReturnsNoDataEnabled()), this.getBooleanPropertyValue(newConfiguration.getEmptyJqlReturnsNoDataEnabled()));
        changedValues.addIfDifferent("admin.generalconfiguration.csv.export.dialog.enabled.label", this.getBooleanPropertyValue(oldConfiguration.getCsvExportDialogDisabled()), this.getBooleanPropertyValue(newConfiguration.getCsvExportDialogDisabled()));
        changedValues.addIfDifferent("admin.generalconfiguration.favourite.filters.jql.execution.timeout.label", oldConfiguration.getFavouriteFiltersGadgetMaxTimeout(), newConfiguration.getFavouriteFiltersGadgetMaxTimeout());
        changedValues.addIfDifferent("admin.generalconfiguration.xsrf.dialog.urlparams.display.label", this.getBooleanPropertyValue(oldConfiguration.getXsrfDialogDisplayParamsEnabled()), this.getBooleanPropertyValue(newConfiguration.getXsrfDialogDisplayParamsEnabled()));
        changedValues.addIfDifferent("admin.generalconfiguration.enable.issue.comment.reactions.label", this.getBooleanPropertyValue(oldConfiguration.getIssueCommentReactionsEnabled()), this.getBooleanPropertyValue(newConfiguration.getIssueCommentReactionsEnabled()));
        changedValues.addIfDifferent("admin.generalconfiguration.stacktrace", this.getBooleanPropertyValue(oldConfiguration.getStackTraceEnabled()), this.getBooleanPropertyValue(newConfiguration.getStackTraceEnabled()));
        return changedValues.build();
    }

    private String getBooleanPropertyValue(Boolean configurationValue) {
        return Boolean.TRUE.equals(configurationValue) ? this.getEnabledI18nString() : this.getDisabledI18nString();
    }

    private String getDisabledI18nString() {
        return this.i18n.getText(DISABLED);
    }

    private String getEnabledI18nString() {
        return this.i18n.getText(ENABLED);
    }
}

