/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface FieldScreenSchemeHandler {
    public void handleFieldScreenSchemeCreated(@Nonnull FieldScreenScheme var1, @Nonnull FieldScreenSchemeItem var2);

    public void handleFieldScreenSchemeUpdated(@Nonnull FieldScreenScheme var1, @Nonnull FieldScreenSchemeData var2);

    public void handleFieldScreenSchemeDeleted(@Nonnull FieldScreenScheme var1, @Nonnull Collection<FieldScreenSchemeItem> var2);

    public void handleFieldScreenSchemeCopied(@Nonnull FieldScreenScheme var1, @Nonnull FieldScreenScheme var2);

    public void handleFieldScreenSchemeItemCreated(@Nonnull FieldScreenScheme var1, @Nonnull FieldScreenSchemeItem var2);

    public void handleFieldScreenSchemeItemUpdated(@Nonnull FieldScreenScheme var1, @Nonnull FieldScreenSchemeItem var2, @Nullable FieldScreen var3);

    public void handleFieldScreenSchemeItemDeleted(@Nonnull FieldScreenScheme var1, @Nullable FieldScreenSchemeItem var2);

    public static class FieldScreenSchemeData {
        final Long id;
        final String name;
        final String description;

        public FieldScreenSchemeData(@Nonnull FieldScreenScheme scheme) {
            Objects.requireNonNull(scheme);
            this.id = scheme.getId();
            this.name = scheme.getName();
            this.description = scheme.getDescription();
        }

        public FieldScreenSchemeData(Long id, String name, String description) {
            this.id = id;
            this.name = name;
            this.description = description;
        }

        public Long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldScreenSchemeData that = (FieldScreenSchemeData)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.description);
        }

        public String toString() {
            return "FieldScreenSchemeData{id=" + this.id + ", name='" + this.name + "', description='" + this.description + "'}";
        }
    }
}

