/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.converters.AuditResources;
import com.atlassian.jira.auditing.handlers.FieldScreenSchemeHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@AuditExceptionSafe
public class FieldScreenSchemeHandlerImpl
implements FieldScreenSchemeHandler {
    private static final AuditType FIELD_SCREEN_SCHEME_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.screens", "jira.auditing.field.screen.scheme.created", CoverageLevel.ADVANCED);
    private static final AuditType FIELD_SCREEN_SCHEME_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.screens", "jira.auditing.field.screen.scheme.updated", CoverageLevel.ADVANCED);
    private static final AuditType FIELD_SCREEN_SCHEME_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.screens", "jira.auditing.field.screen.scheme.deleted", CoverageLevel.ADVANCED);
    private static final AuditType FIELD_SCREEN_SCHEME_COPIED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.screens", "jira.auditing.field.screen.scheme.copied", CoverageLevel.ADVANCED);
    private static final AuditType FIELD_SCREEN_SCHEME_ITEM_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.screens", "jira.auditing.field.screen.scheme.item.created", CoverageLevel.ADVANCED);
    private static final AuditType FIELD_SCREEN_SCHEME_ITEM_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.screens", "jira.auditing.field.screen.scheme.item.updated", CoverageLevel.ADVANCED);
    private static final AuditType FIELD_SCREEN_SCHEME_ITEM_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.screens", "jira.auditing.field.screen.scheme.item.deleted", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public FieldScreenSchemeHandlerImpl(AuditService auditService) {
        this.auditService = Objects.requireNonNull(auditService);
    }

    @Override
    @ThrowSafe
    public void handleFieldScreenSchemeCreated(@Nonnull FieldScreenScheme scheme, @Nonnull FieldScreenSchemeItem fieldScreenSchemeItem) {
        this.auditService.audit(AuditEvent.builder((AuditType)FIELD_SCREEN_SCHEME_CREATED).affectedObjects(FieldScreenSchemeHandlerImpl.concatNonNull(AuditResources.from(scheme), AuditResources.from(fieldScreenSchemeItem))).changedValues((List)ImmutableList.builder().addAll(this.getChangedValues(null, scheme)).addAll(this.getChangedValues(null, fieldScreenSchemeItem)).build()).build());
    }

    @Override
    public void handleFieldScreenSchemeUpdated(@Nonnull FieldScreenScheme scheme, @Nonnull FieldScreenSchemeHandler.FieldScreenSchemeData schemeOld) {
        this.auditService.audit(AuditEvent.builder((AuditType)FIELD_SCREEN_SCHEME_UPDATED).affectedObject(AuditResources.from(scheme)).changedValues(this.getChangedValues(schemeOld, new FieldScreenSchemeHandler.FieldScreenSchemeData(scheme))).build());
    }

    @Override
    public void handleFieldScreenSchemeDeleted(@Nonnull FieldScreenScheme scheme, @Nonnull Collection<FieldScreenSchemeItem> fieldScreenSchemeItems) {
        this.auditService.audit(AuditEvent.builder((AuditType)FIELD_SCREEN_SCHEME_DELETED).affectedObjects(FieldScreenSchemeHandlerImpl.concatNonNull(Stream.of(AuditResources.from(scheme)), fieldScreenSchemeItems.stream().map(AuditResources::from))).changedValues((List)ImmutableList.builder().addAll(this.getChangedValues(scheme, null)).addAll((Iterable)fieldScreenSchemeItems.stream().map(item -> this.getChangedValues((FieldScreenSchemeItem)item, (FieldScreenSchemeItem)null)).flatMap(Collection::stream).collect(Collectors.toList())).build()).build());
    }

    @Override
    public void handleFieldScreenSchemeCopied(@Nonnull FieldScreenScheme scheme, @Nonnull FieldScreenScheme sourceScheme) {
        this.auditService.audit(AuditEvent.builder((AuditType)FIELD_SCREEN_SCHEME_COPIED).affectedObjects(FieldScreenSchemeHandlerImpl.concatNonNull(Stream.of(AuditResources.from(scheme), AuditResources.from(sourceScheme)), scheme.getFieldScreenSchemeItems().stream().map(AuditResources::from))).changedValues((List)ImmutableList.builder().addAll(this.getChangedValues(null, scheme)).addAll((Iterable)scheme.getFieldScreenSchemeItems().stream().map(item -> this.getChangedValues(null, (FieldScreenSchemeItem)item)).flatMap(Collection::stream).collect(Collectors.toList())).build()).build());
    }

    @Override
    public void handleFieldScreenSchemeItemCreated(@Nonnull FieldScreenScheme scheme, @Nonnull FieldScreenSchemeItem schemeItem) {
        this.auditService.audit(AuditEvent.builder((AuditType)FIELD_SCREEN_SCHEME_ITEM_CREATED).affectedObjects(FieldScreenSchemeHandlerImpl.concatNonNull(AuditResources.from(scheme), AuditResources.from(schemeItem))).changedValues(this.getChangedValues(null, schemeItem)).build());
    }

    @Override
    public void handleFieldScreenSchemeItemUpdated(@Nonnull FieldScreenScheme scheme, @Nonnull FieldScreenSchemeItem schemeItem, @Nullable FieldScreen oldScreen) {
        this.auditService.audit(AuditEvent.builder((AuditType)FIELD_SCREEN_SCHEME_ITEM_UPDATED).affectedObjects(FieldScreenSchemeHandlerImpl.concatNonNull(AuditResources.from(scheme), AuditResources.from(schemeItem), oldScreen != null ? AuditResources.from(oldScreen) : null)).changedValues(this.getChangedValues(schemeItem, oldScreen)).build());
    }

    @Override
    public void handleFieldScreenSchemeItemDeleted(@Nonnull FieldScreenScheme scheme, @Nullable FieldScreenSchemeItem schemeItem) {
        this.auditService.audit(AuditEvent.builder((AuditType)FIELD_SCREEN_SCHEME_ITEM_DELETED).affectedObjects(FieldScreenSchemeHandlerImpl.concatNonNull(AuditResources.from(scheme), AuditResources.from(schemeItem))).changedValues(this.getChangedValues(schemeItem, (FieldScreenSchemeItem)null)).build());
    }

    private ImmutableList<ChangedValue> getChangedValues(FieldScreenScheme from, FieldScreenScheme to) {
        return this.getChangedValues((FieldScreenSchemeHandler.FieldScreenSchemeData)Optional.ofNullable(from).map(FieldScreenSchemeHandler.FieldScreenSchemeData::new).orElse(null), (FieldScreenSchemeHandler.FieldScreenSchemeData)Optional.ofNullable(to).map(FieldScreenSchemeHandler.FieldScreenSchemeData::new).orElse(null));
    }

    private ImmutableList<ChangedValue> getChangedValues(FieldScreenSchemeHandler.FieldScreenSchemeData from, FieldScreenSchemeHandler.FieldScreenSchemeData to) {
        return new ChangedValuesBuilder().addIfDifferent("common.words.description", Optional.ofNullable(from).map(FieldScreenSchemeHandler.FieldScreenSchemeData::getDescription).orElse(null), Optional.ofNullable(to).map(FieldScreenSchemeHandler.FieldScreenSchemeData::getDescription).orElse(null)).addIfDifferent("common.words.name", Optional.ofNullable(from).map(FieldScreenSchemeHandler.FieldScreenSchemeData::getName).orElse(null), Optional.ofNullable(to).map(FieldScreenSchemeHandler.FieldScreenSchemeData::getName).orElse(null)).build();
    }

    private ImmutableList<ChangedValue> getChangedValues(@Nullable FieldScreenSchemeItem from, @Nullable FieldScreenSchemeItem to) {
        String key = this.getIssueOperationKey(Optional.ofNullable(from).orElse(to));
        Function<FieldScreenSchemeItem, String> toScreenName = item -> Optional.ofNullable(item).map(FieldScreenSchemeItem::getFieldScreen).map(FieldScreen::getName).orElse(null);
        return new ChangedValuesBuilder().add(key, toScreenName.apply(from), toScreenName.apply(to)).build();
    }

    private ImmutableList<ChangedValue> getChangedValues(@Nullable FieldScreenSchemeItem fieldScreenSchemeItem, @Nullable FieldScreen oldScreen) {
        String key = this.getIssueOperationKey(fieldScreenSchemeItem);
        Function<FieldScreenSchemeItem, String> toScreenName = item -> Optional.ofNullable(item).map(FieldScreenSchemeItem::getFieldScreen).map(FieldScreen::getName).orElse(null);
        return new ChangedValuesBuilder().add(key, Optional.ofNullable(oldScreen).map(FieldScreen::getName).orElse(null), toScreenName.apply(fieldScreenSchemeItem)).build();
    }

    private String getIssueOperationKey(@Nullable FieldScreenSchemeItem fieldScreenSchemeItem) {
        String key = "jira.auditing.field.screen.scheme.item.operation.unknown";
        if (fieldScreenSchemeItem != null) {
            ScreenableIssueOperation issueOperation = fieldScreenSchemeItem.getIssueOperation();
            if (issueOperation != null) {
                if (IssueOperations.CREATE_ISSUE_OPERATION.getId().equals(issueOperation.getId())) {
                    key = "jira.auditing.field.screen.scheme.item.operation.create";
                } else if (IssueOperations.EDIT_ISSUE_OPERATION.getId().equals(issueOperation.getId())) {
                    key = "jira.auditing.field.screen.scheme.item.operation.edit";
                } else if (IssueOperations.VIEW_ISSUE_OPERATION.getId().equals(issueOperation.getId())) {
                    key = "jira.auditing.field.screen.scheme.item.operation.view";
                }
            } else {
                key = "jira.auditing.field.screen.scheme.item.operation.default";
            }
        }
        return key;
    }

    private static List<AuditResource> concatNonNull(AuditResource ... items) {
        return Arrays.stream(items).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<AuditResource> concatNonNull(Stream<AuditResource> ... items) {
        return Arrays.stream(items).flatMap(Function.identity()).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

