/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.handlers.FlowRequestEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.oauth2.client.api.lib.event.FlowRequestCompletedEvent;
import com.atlassian.oauth2.client.api.lib.event.FlowRequestSuccessfullyCompletedEvent;
import com.atlassian.oauth2.client.api.lib.event.FlowRequestUnsuccessfullyCompletedEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.LinkedHashMap;
import java.util.Map;

@AuditExceptionSafe
public class FlowRequestEventHandlerImpl
implements FlowRequestEventHandler {
    @VisibleForTesting
    static final String FLOW_COMPLETED_SUCCESSFULLY = "jira.auditing.oauth2.flow.completed.successfully";
    @VisibleForTesting
    static final String FLOW_UNSUCCESSFULLY_COMPLETED_KEY = "jira.auditing.oauth2.flow.completed.unsuccessfully";
    @VisibleForTesting
    static final String FLOW_COMPLETED_KEY = "jira.auditing.oauth2.flow.completed";
    @VisibleForTesting
    static final String FLOW_REQUEST_ID_KEY = "jira.auditing.oauth2.flow.flowRequestId";
    @VisibleForTesting
    static final String CLIENT_ID_KEY = "jira.auditing.oauth2.flow.clientId";
    @VisibleForTesting
    static final String PROVIDER_TYPE_KEY = "jira.auditing.oauth2.flow.providerType";
    @VisibleForTesting
    static final String GRANT_TYPE_KEY = "jira.auditing.oauth2.flow.grantType";
    @VisibleForTesting
    static final String ERROR_MESSAGE_KEY = "jira.auditing.oauth2.flow.errorMessage";
    @VisibleForTesting
    static final AuditType FLOW_SUCCESSFULLY_COMPLETED = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, "jira.auditing.category.security", "jira.auditing.oauth2.flow.completed.successfully", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType FLOW_UNSUCCESSFULLY_COMPLETED = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, "jira.auditing.category.security", "jira.auditing.oauth2.flow.completed.unsuccessfully", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType FLOW_COMPLETED = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, "jira.auditing.category.security", "jira.auditing.oauth2.flow.completed", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public FlowRequestEventHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleFlowRequestCompleted(FlowRequestCompletedEvent event) {
        if (event instanceof FlowRequestSuccessfullyCompletedEvent) {
            this.handleFlowRequestSuccessfullyCompleted((FlowRequestSuccessfullyCompletedEvent)event);
        } else if (event instanceof FlowRequestUnsuccessfullyCompletedEvent) {
            this.handleFlowRequestUnsuccessfullyCompleted((FlowRequestUnsuccessfullyCompletedEvent)event);
        } else {
            this.handleGenericFlowRequestCompleted(event);
        }
    }

    private void handleFlowRequestSuccessfullyCompleted(FlowRequestSuccessfullyCompletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)FLOW_SUCCESSFULLY_COMPLETED).extraAttributes(AuditEntitiesUtils.newAuditAttributes(this.getFlowCompletedAttributes((FlowRequestCompletedEvent)event))).build());
    }

    private void handleFlowRequestUnsuccessfullyCompleted(FlowRequestUnsuccessfullyCompletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)FLOW_UNSUCCESSFULLY_COMPLETED).extraAttributes(AuditEntitiesUtils.newAuditAttributes(this.getFlowUnsuccessfullyCompletedAttributes(event))).build());
    }

    private void handleGenericFlowRequestCompleted(FlowRequestCompletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)FLOW_COMPLETED).extraAttributes(AuditEntitiesUtils.newAuditAttributes(this.getFlowCompletedAttributes(event))).build());
    }

    private Map<String, String> getFlowCompletedAttributes(FlowRequestCompletedEvent event) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put(FLOW_REQUEST_ID_KEY, event.getFlowRequestId());
        attributes.put(CLIENT_ID_KEY, event.getClientId());
        attributes.put(PROVIDER_TYPE_KEY, event.getProviderType());
        attributes.put(GRANT_TYPE_KEY, event.getGrantType());
        return attributes;
    }

    private Map<String, String> getFlowUnsuccessfullyCompletedAttributes(FlowRequestUnsuccessfullyCompletedEvent event) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put(FLOW_REQUEST_ID_KEY, event.getFlowRequestId());
        attributes.put(CLIENT_ID_KEY, event.getClientId());
        attributes.put(PROVIDER_TYPE_KEY, event.getProviderType());
        attributes.put(GRANT_TYPE_KEY, event.getGrantType());
        attributes.put(ERROR_MESSAGE_KEY, event.getErrorMessage());
        return attributes;
    }
}

