/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.handlers.ImportExportHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.bc.dataimport.DataImportEvent;
import com.atlassian.jira.bc.dataimport.ExportStartedEvent;
import com.atlassian.jira.bc.dataimport.ExportSuccessfulEvent;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ImportStartedEvent;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import java.util.Date;

@AuditExceptionSafe
public class ImportExportHandlerImpl
implements ImportExportHandler {
    private static final String I18N_USER_SYSTEM = "jira.auditing.export.user.system";
    private static final String I18N_IMPORT_STARTED = "jira.auditing.import.started";
    private static final String I18N_IMPORT_TYPE = "jira.auditing.import.type";
    private static final String I18N_IMPORT_TYPE_CLOUD = "jira.auditing.import.type.cloud";
    private static final String I18N_IMPORT_TYPE_SERVER = "jira.auditing.import.type.server";
    private static final String I18N_IMPORT_TYPE_UNKNOWN = "jira.auditing.import.type.unknown";
    private static final String I18N_IMPORT_USER = "jira.auditing.import.user";
    private static final String I18N_IMPORT_COMPLETED = "jira.auditing.import.completed";
    private static final String I18N_IMPORT_COMPLETED_SUCCESSFUL = "jira.auditing.import.completed.successful";
    private static final String I18N_IMPORT_SUCCESSFUL_TRUE = "jira.auditing.import.completed.true";
    private static final String I18N_IMPORT_SUCCESSFUL_FALSE = "jira.auditing.import.completed.false";
    private static final String I18N_EXPORT_STARTED = "jira.auditing.export.started";
    private static final String I18N_EXPORT_SUCCESSFUL = "jira.auditing.export.successful";
    private static final String I18N_EXPORT_TIME = "jira.auditing.export.started.time";
    private static final String I18N_EXPORT_DURATION = "jira.auditing.export.started.duration";
    private static final String I18N_EXPORT_USER = "jira.auditing.export.started.user";
    private static final String I18N_EXPORT_FILENAME = "jira.auditing.export.started.filename";
    @VisibleForTesting
    static final AuditType EXPORT_SUCCESSFUL = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.EXPORT_IMPORT, "jira.auditing.export.successful", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType EXPORT_STARTED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.EXPORT_IMPORT, "jira.auditing.export.started", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType IMPORT_COMPLETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.EXPORT_IMPORT, "jira.auditing.import.completed", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType IMPORT_STARTED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.EXPORT_IMPORT, "jira.auditing.import.started", CoverageLevel.BASE);
    private final AuditService auditService;
    private final DateTimeFormatter dateTimeFormatter;
    private final JiraDurationUtils jiraDurationUtils;
    private final I18nHelper i18n;

    public ImportExportHandlerImpl(AuditService auditService, DateTimeFormatter dateTimeFormatter, JiraDurationUtils jiraDurationUtils, I18nHelper i18n) {
        this.auditService = auditService;
        this.dateTimeFormatter = dateTimeFormatter.withStyle(DateTimeStyle.COMPLETE);
        this.jiraDurationUtils = jiraDurationUtils;
        this.i18n = i18n;
    }

    @Override
    public void onExportSuccessfulEvent(ExportSuccessfulEvent event) {
        String durationString = this.jiraDurationUtils.getFormattedDuration(Long.valueOf(event.getExportDuration() / 1000L));
        this.auditService.audit(AuditEvent.builder((AuditType)EXPORT_SUCCESSFUL).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_EXPORT_TIME, this.dateTimeFormatter.format(new Date(event.getXmlExportTime())))).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_EXPORT_DURATION, durationString)).build());
    }

    @Override
    public void onExportStartedEvent(ExportStartedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)EXPORT_STARTED).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_EXPORT_FILENAME, event.getFilename())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_EXPORT_USER, event.getLoggedInUser() == null ? this.i18n.getText(I18N_USER_SYSTEM) : event.getLoggedInUser().getName())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_EXPORT_TIME, this.dateTimeFormatter.format(new Date(event.getXmlExportTime())))).build());
    }

    @Override
    public void onImportStartedEvent(ImportStartedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)IMPORT_STARTED).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_IMPORT_TYPE, this.mapXmlImportType(event.getXmlImportType()))).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_EXPORT_TIME, this.dateTimeFormatter.format((Date)event.getXmlExportTime().map(Date::new).getOrNull()))).build());
    }

    @Override
    public void onImportCompletedEvent(ImportCompletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)IMPORT_COMPLETED).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_IMPORT_TYPE, this.mapXmlImportType(event.getXmlImportType()))).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_EXPORT_TIME, this.dateTimeFormatter.format((Date)event.getXmlExportTime().map(Date::new).getOrNull()))).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_IMPORT_COMPLETED_SUCCESSFUL, event.isImportSuccessful() ? this.i18n.getText(I18N_IMPORT_SUCCESSFUL_TRUE) : this.i18n.getText(I18N_IMPORT_SUCCESSFUL_FALSE))).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_IMPORT_USER, event.getUser() == null ? this.i18n.getText(I18N_USER_SYSTEM) : event.getUser().getName())).build());
    }

    private String mapXmlImportType(DataImportEvent.ImportType xmlImportType) {
        switch (xmlImportType) {
            case CLOUD: {
                return this.i18n.getText(I18N_IMPORT_TYPE_CLOUD);
            }
            case SERVER: {
                return this.i18n.getText(I18N_IMPORT_TYPE_SERVER);
            }
        }
        return this.i18n.getText(I18N_IMPORT_TYPE_UNKNOWN);
    }
}

