/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.converters.AuditResources;
import com.atlassian.jira.auditing.handlers.IssueLinkingHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.issue.link.IssueLinkCreatedEvent;
import com.atlassian.jira.event.issue.link.IssueLinkDeletedEvent;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;

@AuditExceptionSafe
public class IssueLinkingHandlerImpl
implements IssueLinkingHandler {
    private static final AuditType ISSUELINKING_ACTIVATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issue", "jira.auditing.issuelinking.activated", CoverageLevel.ADVANCED);
    private static final AuditType ISSUELINKING_DEACTIVATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issue", "jira.auditing.issuelinking.deactivated", CoverageLevel.ADVANCED);
    private static final AuditType ISSUELINKING_TYPE_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issue", "jira.auditing.issuelinking.type.created", CoverageLevel.ADVANCED);
    private static final AuditType ISSUELINKING_TYPE_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issue", "jira.auditing.issuelinking.type.updated", CoverageLevel.ADVANCED);
    private static final AuditType ISSUELINKING_TYPE_REMOVED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issue", "jira.auditing.issuelinking.type.removed", CoverageLevel.ADVANCED);
    private static final AuditType ISSUELINK_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, "jira.auditing.category.issue", "jira.auditing.issuelink.created", CoverageLevel.FULL);
    private static final AuditType ISSUELINK_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, "jira.auditing.category.issue", "jira.auditing.issuelink.deleted", CoverageLevel.FULL);
    private final AuditService auditService;

    public IssueLinkingHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleIssueLinkingDeactivation() {
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUELINKING_DEACTIVATED).build());
    }

    @Override
    @ThrowSafe
    public void handleIssueLinkingActivation() {
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUELINKING_ACTIVATED).build());
    }

    @Override
    @ThrowSafe
    public void handleIssueLinkCreation(IssueLinkCreatedEvent event) {
        IssueLink issueLink = event.getIssueLink();
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUELINK_CREATED).affectedObject(AuditResources.from(issueLink.getSourceObject())).changedValues(new ChangedValuesBuilder().add("jira.auditing.issuelink.type", issueLink.getIssueLinkType().getInward()).add("jira.auditing.issuelink.target", issueLink.getDestinationObject().getKey()).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleIssueLinkDeletion(IssueLinkDeletedEvent event) {
        IssueLink issueLink = event.getIssueLink();
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUELINK_DELETED).affectedObject(AuditResources.from(issueLink.getSourceObject())).changedValues(new ChangedValuesBuilder().add("jira.auditing.issuelink.type", issueLink.getIssueLinkType().getInward(), null).add("jira.auditing.issuelink.target", issueLink.getDestinationObject().getKey(), null).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleIssueLinkTypeRemove(IssueLinkType linkType) {
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUELINKING_TYPE_REMOVED).affectedObject(AuditResources.from(linkType)).changedValues(new ChangedValuesBuilder().add("common.words.name", linkType.getName(), null).add("admin.issuelinking.inward.description", linkType.getInward(), null).add("admin.issuelinking.outward.description", linkType.getOutward(), null).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleIssueLinkTypeCreation(IssueLinkType linkType) {
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUELINKING_TYPE_CREATED).affectedObject(AuditResources.from(linkType)).changedValues(new ChangedValuesBuilder().add("common.words.name", linkType.getName()).add("admin.issuelinking.inward.description", linkType.getInward()).add("admin.issuelinking.outward.description", linkType.getOutward()).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleIssueLinkTypeCreation(String linkTypeName) {
        IssueLinkTypeManager issueLinkTypeManager = (IssueLinkTypeManager)ComponentAccessor.getComponent(IssueLinkTypeManager.class);
        IssueLinkType issueLinkType = (IssueLinkType)issueLinkTypeManager.getIssueLinkTypesByName(linkTypeName).iterator().next();
        this.handleIssueLinkTypeCreation(issueLinkType);
    }

    @Override
    @ThrowSafe
    public void handleIssueLinkTypeUpdate(IssueLinkType existingIssueLinkType, String name, String outward, String inward) {
        this.auditService.audit(AuditEvent.builder((AuditType)ISSUELINKING_TYPE_UPDATED).affectedObject(AuditResources.from(existingIssueLinkType)).changedValues(new ChangedValuesBuilder().add("common.words.name", existingIssueLinkType.getName(), name).add("admin.issuelinking.inward.description", existingIssueLinkType.getInward(), inward).add("admin.issuelinking.outward.description", existingIssueLinkType.getOutward(), outward).build()).build());
    }
}

