/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.IssueSecurityLevelHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.issue.security.IssueSecurityLevelUpdatedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;

@AuditExceptionSafe
public final class IssueSecurityLevelHandlerImpl
implements IssueSecurityLevelHandler {
    @VisibleForTesting
    static final AuditType LEVEL_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, "jira.auditing.category.issue.security.level", "jira.auditing.issue.security.level.updated", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public IssueSecurityLevelHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void onIssueSecurityLevelUpdatedEvent(IssueSecurityLevelUpdatedEvent event) {
        ImmutableList<ChangedValue> build = new ChangedValuesBuilder().addIfDifferent("jira.auditing.status.name", event.getOldName(), event.getNewName()).addIfDifferent("jira.auditing.status.description", event.getOldDescription(), event.getNewDescription()).build();
        this.auditService.audit(AuditEvent.builder((AuditType)LEVEL_UPDATED).affectedObject(AuditEntitiesUtils.newAuditResource(event.getNewName(), AssociatedItem.Type.ISSUE_SECURITY_LEVEL.name(), String.valueOf(event.getSchemeId()))).changedValues(build).build());
    }
}

