/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.IssueTypeAuditHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.config.SubTasksStateChangedEvent;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
@AuditExceptionSafe
public class IssueTypeAuditHandlerImpl
implements IssueTypeAuditHandler {
    @VisibleForTesting
    static final AuditType ISSUE_TYPE_SUB_TASK_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issuetypes", "jira.auditing.issue.type.subtask.created", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType ISSUE_TYPE_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issuetypes", "jira.auditing.issue.type.created", CoverageLevel.BASE);
    @VisibleForTesting
    static final AuditType ISSUE_TYPE_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issuetypes", "jira.auditing.issue.type.updated", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType ISSUE_TYPE_SUB_TASK_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issuetypes", "jira.auditing.issue.type.subtask.updated", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType ISSUE_TYPE_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issuetypes", "jira.auditing.issue.type.deleted", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType ISSUE_TYPE_SUB_TASK_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issuetypes", "jira.auditing.issue.type.subtask.deleted", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType SUBTASKS_ENABLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issuetypes", "jira.auditing.subtasks.enabled", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType SUBTASKS_DISABLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.issuetypes", "jira.auditing.subtasks.disabled", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public IssueTypeAuditHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeCreated(IssueType issueType) {
        if (issueType.isSubTask()) {
            this.auditEntry(issueType, ISSUE_TYPE_SUB_TASK_CREATED);
        } else {
            this.auditEntry(issueType, ISSUE_TYPE_CREATED);
        }
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeUpdated(IssueType oldIssueType, IssueType newIssueType) {
        AuditType auditType = newIssueType.isSubTask() ? ISSUE_TYPE_SUB_TASK_UPDATED : ISSUE_TYPE_UPDATED;
        this.auditService.audit(AuditEvent.builder((AuditType)auditType).affectedObject(AuditResource.builder((String)newIssueType.getName(), (String)AssociatedItem.Type.ISSUE_TYPE.name()).id(newIssueType.getId()).build()).changedValues(new ChangedValuesBuilder().addIfDifferent("jira.auditing.issue.type.name", oldIssueType.getName(), newIssueType.getName()).addIfDifferent("jira.auditing.issue.type.description", oldIssueType.getDescription(), newIssueType.getDescription()).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleIssueTypeDeleted(IssueType issueType) {
        if (issueType.isSubTask()) {
            this.auditEntry(issueType, ISSUE_TYPE_SUB_TASK_DELETED);
        } else {
            this.auditEntry(issueType, ISSUE_TYPE_DELETED);
        }
    }

    @Override
    @ThrowSafe
    public void handleSubTasksStateChanged(SubTasksStateChangedEvent event) {
        AuditType auditType = event.isEnabled() ? SUBTASKS_ENABLED : SUBTASKS_DISABLED;
        this.auditService.audit(AuditEvent.builder((AuditType)auditType).build());
    }

    private void auditEntry(IssueType issueType, AuditType auditType) {
        String description = StringUtils.defaultString((String)issueType.getDescription());
        String name = StringUtils.defaultString((String)issueType.getName());
        this.auditService.audit(AuditEvent.builder((AuditType)auditType).affectedObject(AuditResource.builder((String)issueType.getName(), (String)AssociatedItem.Type.ISSUE_TYPE.name()).id(issueType.getId()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.type.description", description)).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.issue.type.name", name)).build());
    }
}

