/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.MonitoringEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.monitoring.jmx.JmxConfigurationChangedEvent;
import com.google.common.annotations.VisibleForTesting;

@AuditExceptionSafe
public final class MonitoringEventHandlerImpl
implements MonitoringEventHandler {
    @VisibleForTesting
    static final AuditType MONITORING_JMX_ENABLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.system", "jira.auditing.monitoring.jmx.enabled", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType MONITORING_JMX_DISABLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.system", "jira.auditing.monitoring.jmx.disabled", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public MonitoringEventHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    public RecordRequest onJmxConfigurationChanged(JmxConfigurationChangedEvent event) {
        return new RecordRequest("jira.auditing.category.system", this.getSummary(event)).withActionI18nKey(this.getSummary(event));
    }

    @Override
    @ThrowSafe
    public void handleJmxConfigurationChanged(JmxConfigurationChangedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)(event.isEnabled() ? MONITORING_JMX_ENABLED : MONITORING_JMX_DISABLED)).build());
    }

    private String getSummary(JmxConfigurationChangedEvent event) {
        return event.isEnabled() ? "jira.auditing.monitoring.jmx.enabled" : "jira.auditing.monitoring.jmx.disabled";
    }
}

