/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.handlers.PinnedCommentHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.issue.comments.Comment;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@AuditExceptionSafe
public class PinnedCommentHandlerImpl
implements PinnedCommentHandler {
    private static final AuditType COMMENT_IS_PINNED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, "jira.auditing.category.issue", "jira.auditing.issue.comment.pinned", CoverageLevel.FULL);
    private static final AuditType COMMENT_IS_UNPINNED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, "jira.auditing.category.issue", "jira.auditing.issue.comment.unpinned", CoverageLevel.FULL);
    private final AuditService auditService;

    public PinnedCommentHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleCommentPinned(@NotNull Comment comment) {
        this.handlePinnedComment(comment, COMMENT_IS_PINNED);
    }

    @Override
    @ThrowSafe
    public void handleCommentUnpinned(@NotNull Comment comment) {
        this.handlePinnedComment(comment, COMMENT_IS_UNPINNED);
    }

    private void handlePinnedComment(@NotNull Comment comment, AuditType auditType) {
        Objects.requireNonNull(comment);
        String issueKey = comment.getIssue().getKey();
        Long commentId = comment.getId();
        this.auditService.audit(AuditEvent.builder((AuditType)auditType).affectedObjects(Arrays.asList(AuditResource.builder((String)issueKey, (String)AssociatedItem.Type.ISSUE.name()).id(commentId.toString()).build(), AuditResource.builder((String)("COMMENT-" + commentId), (String)AssociatedItem.Type.COMMENT.name()).id(issueKey + " " + commentId).build())).build());
    }
}

