/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.handlers.PluginEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginInstalledEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;

@AuditExceptionSafe
public class PluginEventHandlerImpl
implements PluginEventHandler {
    private static final AuditType PLUGIN_INSTALLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.applications", "jira.auditing.plugin.installed", CoverageLevel.BASE);
    private static final AuditType PLUGIN_UNINSTALLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.applications", "jira.auditing.plugin.uninstalled", CoverageLevel.BASE);
    private static final AuditType PLUGIN_UPGRADED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.applications", "jira.auditing.plugin.upgraded", CoverageLevel.BASE);
    private static final AuditType PLUGIN_ENABLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.applications", "jira.auditing.plugin.enabled", CoverageLevel.BASE);
    private static final AuditType PLUGIN_DISABLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.applications", "jira.auditing.plugin.disabled", CoverageLevel.BASE);
    private static final String I18N_PROPERTY_PLUGIN_KEY = "jira.auditing.plugin.key";
    private static final String I18N_PROPERTY_PLUGIN_VERSION = "jira.auditing.plugin.version";
    private final AuditService auditService;

    public PluginEventHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handlePluginInstalledEvent(PluginInstalledEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PLUGIN_INSTALLED).affectedObject(AuditResource.builder((String)event.getPlugin().getName(), (String)AssociatedItem.Type.PLUGIN.name()).id(event.getPlugin().getKey()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PROPERTY_PLUGIN_KEY, event.getPlugin().getKey())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PROPERTY_PLUGIN_VERSION, event.getPlugin().getPluginInformation().getVersion())).build());
    }

    @Override
    @ThrowSafe
    public void handlePluginUninstalledEvent(PluginUninstalledEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PLUGIN_UNINSTALLED).affectedObject(AuditResource.builder((String)event.getPlugin().getName(), (String)AssociatedItem.Type.PLUGIN.name()).id(event.getPlugin().getKey()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PROPERTY_PLUGIN_KEY, event.getPlugin().getKey())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PROPERTY_PLUGIN_VERSION, event.getPlugin().getPluginInformation().getVersion())).build());
    }

    @Override
    @ThrowSafe
    public void handlePluginUpgradedEvent(PluginUpgradedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PLUGIN_UPGRADED).affectedObject(AuditResource.builder((String)event.getPlugin().getName(), (String)AssociatedItem.Type.PLUGIN.name()).id(event.getPlugin().getKey()).build()).changedValue(AuditEntitiesUtils.newChangedValue(I18N_PROPERTY_PLUGIN_VERSION, event.getPlugin().getPluginInformation().getVersion())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PROPERTY_PLUGIN_KEY, event.getPlugin().getKey())).build());
    }

    @Override
    @ThrowSafe
    public void handlePluginEnabledEvent(PluginEnabledEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PLUGIN_ENABLED).affectedObject(AuditResource.builder((String)event.getPlugin().getName(), (String)AssociatedItem.Type.PLUGIN.name()).id(event.getPlugin().getKey()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PROPERTY_PLUGIN_KEY, event.getPlugin().getKey())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PROPERTY_PLUGIN_VERSION, event.getPlugin().getPluginInformation().getVersion())).build());
    }

    @Override
    @ThrowSafe
    public void handlePluginDisabledEvent(PluginDisabledEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PLUGIN_DISABLED).affectedObject(AuditResource.builder((String)event.getPlugin().getName(), (String)AssociatedItem.Type.PLUGIN.name()).id(event.getPlugin().getKey()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PROPERTY_PLUGIN_KEY, event.getPlugin().getKey())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PROPERTY_PLUGIN_VERSION, event.getPlugin().getPluginInformation().getVersion())).build());
    }
}

