/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.handlers.PriorityEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.fields.PriorityCreatedEvent;
import com.atlassian.jira.event.fields.PriorityDeletedEvent;
import com.atlassian.jira.event.fields.PriorityEditedEvent;
import com.atlassian.jira.event.fields.PriorityMovedEvent;

@AuditExceptionSafe
public class PriorityEventHandlerImpl
implements PriorityEventHandler {
    @VisibleForTesting
    static final AuditType PRIORITY_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.fields", "jira.auditing.priority.created", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType PRIORITY_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.fields", "jira.auditing.priority.updated", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType PRIORITY_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.fields", "jira.auditing.priority.deleted", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType PRIORITY_ORDER_CHANGED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.fields", "jira.auditing.priority.order.changed", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final String I18N_PRIORITY_NAME = "jira.auditing.priority.name";
    @VisibleForTesting
    static final String I18N_PRIORITY_DESCRIPTION = "jira.auditing.priority.description";
    @VisibleForTesting
    static final String I18N_PRIORITY_ICON_URL = "jira.auditing.priority.icon.url";
    @VisibleForTesting
    static final String I18N_PRIORITY_COLOR = "jira.auditing.priority.color";
    @VisibleForTesting
    static final String I18N_PRIORITY_SEQUENCE = "jira.auditing.priority.sequence";
    private final AuditService auditService;

    public PriorityEventHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handlePriorityCreated(PriorityCreatedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PRIORITY_CREATED).affectedObject(AuditResource.builder((String)event.getPriority().getName(), (String)AssociatedItem.Type.PRIORITY.name()).id(event.getPriority().getId()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PRIORITY_NAME, event.getPriority().getName())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PRIORITY_DESCRIPTION, event.getPriority().getDescription())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PRIORITY_ICON_URL, event.getPriority().getIconUrl())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_PRIORITY_COLOR, event.getPriority().getStatusColor())).build());
    }

    @Override
    @ThrowSafe
    public void handlePriorityEdited(PriorityEditedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PRIORITY_UPDATED).affectedObject(AuditResource.builder((String)event.getUpdatedPriority().getName(), (String)AssociatedItem.Type.PRIORITY.name()).id(event.getUpdatedPriority().getId()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)I18N_PRIORITY_NAME).from(event.getOriginalPriority().getName()).to(event.getUpdatedPriority().getName()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)I18N_PRIORITY_DESCRIPTION).from(event.getOriginalPriority().getDescription()).to(event.getUpdatedPriority().getDescription()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)I18N_PRIORITY_COLOR).from(event.getOriginalPriority().getStatusColor()).to(event.getUpdatedPriority().getStatusColor()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)I18N_PRIORITY_ICON_URL).from(event.getOriginalPriority().getIconUrl()).to(event.getUpdatedPriority().getIconUrl()).build()).build());
    }

    @Override
    @ThrowSafe
    public void handlePriorityDeleted(PriorityDeletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PRIORITY_DELETED).affectedObject(AuditResource.builder((String)event.getPriority().getName(), (String)AssociatedItem.Type.PRIORITY.name()).build()).build());
    }

    @Override
    @ThrowSafe
    public void handlePriorityMoved(PriorityMovedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)PRIORITY_ORDER_CHANGED).affectedObject(AuditResource.builder((String)event.getPriority().getName(), (String)AssociatedItem.Type.PRIORITY.name()).id(event.getPriority().getId()).build()).changedValue(ChangedValue.fromI18nKeys((String)I18N_PRIORITY_SEQUENCE).from(event.getFrom().toString()).to(event.getTo().toString()).build()).build());
    }
}

