/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.ProjectLeadHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.project.Project;

@AuditExceptionSafe
public class ProjectLeadHandlerImpl
implements ProjectLeadHandler {
    private static final AuditType PROJECT_LEAD_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.PERMISSIONS, "jira.auditing.category.projects", "jira.auditing.project.lead.updated", CoverageLevel.ADVANCED);
    private final AuditService auditService;

    public ProjectLeadHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleProjectLeadUpdated(Project projectUpdated, String oldProjectLeadKey, String newProjectLeadKey) {
        this.auditService.audit(AuditEvent.builder((AuditType)PROJECT_LEAD_UPDATED).affectedObject(AuditResource.builder((String)projectUpdated.getName(), (String)AssociatedItem.Type.PROJECT.name()).id(Long.toString(projectUpdated.getId())).build()).changedValues(new ChangedValuesBuilder().add("admin.permission.types.project.lead", oldProjectLeadKey, newProjectLeadKey).build()).build());
    }
}

