/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.handlers.ReindexingAuditHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.util.JiraDurationUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@AuditExceptionSafe
public class ReindexingAuditHandlerImpl
implements ReindexingAuditHandler {
    @VisibleForTesting
    static final AuditType FULL_REINDEX_STARTED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.indexing", "jira.auditing.indexing.full.reindex.started", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType BACKGROUND_REINDEX_STARTED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.indexing", "jira.auditing.indexing.background.reindex.started", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType FULL_REINDEX_COMPLETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.indexing", "jira.auditing.indexing.full.reindex.completed", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType BACKGROUND_REINDEX_COMPLETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.indexing", "jira.auditing.indexing.background.reindex.completed", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType BACKGROUND_REINDEX_CANCELLED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.indexing", "jira.auditing.indexing.background.reindex.cancelled", CoverageLevel.ADVANCED);
    private AuditService auditService;
    private final JiraDurationUtils durationUtils;
    private final DateTimeFormatter dateTimeFormatter;

    public ReindexingAuditHandlerImpl(AuditService auditService, JiraDurationUtils durationUtils, DateTimeFormatter dateTimeFormatter) {
        this.auditService = Objects.requireNonNull(auditService);
        this.durationUtils = Objects.requireNonNull(durationUtils);
        this.dateTimeFormatter = Objects.requireNonNull(dateTimeFormatter).withStyle(DateTimeStyle.COMPLETE);
    }

    @Override
    @ThrowSafe
    public void handleReindexingStarted(boolean isBackgroundReindex) {
        AuditType auditType = isBackgroundReindex ? BACKGROUND_REINDEX_STARTED : FULL_REINDEX_STARTED;
        AuditEvent auditEvent = AuditEvent.builder((AuditType)auditType).build();
        this.auditService.audit(auditEvent);
    }

    @Override
    @ThrowSafe
    public void handleReindexingCompleted(long startTime, long duration, boolean wasBackgroundReindex, long reindexedIssuesCount, long reindexedArchivedIssuesCount) {
        AuditType auditType = wasBackgroundReindex ? BACKGROUND_REINDEX_COMPLETED : FULL_REINDEX_COMPLETED;
        AuditEvent auditEvent = AuditEvent.builder((AuditType)auditType).extraAttributes((Collection)ImmutableList.of((Object)AuditEntitiesUtils.newAuditAttribute("jira.auditing.indexing.start.time", this.dateTimeFormatter.format(new Date(startTime))), (Object)AuditEntitiesUtils.newAuditAttribute("jira.auditing.indexing.duration", this.durationUtils.getFormattedDuration(Long.valueOf(TimeUnit.MILLISECONDS.toSeconds(duration)))), (Object)AuditEntitiesUtils.newAuditAttribute("jira.auditing.indexing.reindexed.issues.count", Objects.toString(reindexedIssuesCount)), (Object)AuditEntitiesUtils.newAuditAttribute("jira.auditing.indexing.reindexed.archived.issues.count", Objects.toString(reindexedArchivedIssuesCount)))).build();
        this.auditService.audit(auditEvent);
    }

    @Override
    @ThrowSafe
    public void handleBackgroundReindexingCancelled(long startTime) {
        AuditEvent auditEvent = AuditEvent.builder((AuditType)BACKGROUND_REINDEX_CANCELLED).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.indexing.start.time", this.dateTimeFormatter.format(new Date(startTime)))).build();
        this.auditService.audit(auditEvent);
    }
}

