/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.ResolutionAuditHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.google.common.base.Strings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@AuditExceptionSafe
public class ResolutionAuditHandlerImpl
implements ResolutionAuditHandler {
    @VisibleForTesting
    public static final String DESCRIPTION = "common.concepts.description";
    @VisibleForTesting
    public static final String NAME = "common.concepts.name";
    private static final AuditType RESOLUTION_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.workflows", "jira.auditing.resolutions.created", CoverageLevel.BASE);
    private static final AuditType RESOLUTION_EDITED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.workflows", "jira.auditing.resolutions.edited", CoverageLevel.BASE);
    private static final AuditType RESOLUTION_REMOVED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.workflows", "jira.auditing.resolutions.removed", CoverageLevel.BASE);
    private static final AuditType RESOLUTION_MOVED_UP = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.workflows", "jira.auditing.resolutions.moved.up", CoverageLevel.BASE);
    private static final AuditType RESOLUTION_MOVED_DOWN = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.workflows", "jira.auditing.resolutions.moved.down", CoverageLevel.BASE);
    private static final AuditType RESOLUTION_SET_AS_DEFAULT = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.workflows", "jira.auditing.resolutions.set.as.default", CoverageLevel.BASE);
    private final AuditService auditService;

    public ResolutionAuditHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleResolutionCreated(String resolutionName, String resolutionId, String description) {
        Objects.requireNonNull(resolutionName);
        Objects.requireNonNull(resolutionId);
        this.auditService.audit(AuditEvent.builder((AuditType)RESOLUTION_CREATED).affectedObject(this.resolutionAuditResource(resolutionId, resolutionName)).extraAttribute(AuditEntitiesUtils.newAuditAttribute(DESCRIPTION, description)).build());
    }

    @Override
    @ThrowSafe
    public void handleResolutionEdited(String resolutionId, String oldName, String oldDescription, String newName, String newDescription) {
        Objects.requireNonNull(resolutionId);
        Objects.requireNonNull(oldName);
        Objects.requireNonNull(oldDescription);
        Objects.requireNonNull(newName);
        Objects.requireNonNull(newDescription);
        this.auditService.audit(AuditEvent.builder((AuditType)RESOLUTION_EDITED).affectedObject(this.resolutionAuditResource(resolutionId, newName)).changedValues(new ChangedValuesBuilder().addIfDifferent(DESCRIPTION, oldDescription, newDescription).addIfDifferent(NAME, oldName, newName).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleResolutionRemoved(String resolutionId, String resolutionName) {
        Objects.requireNonNull(resolutionId);
        Objects.requireNonNull(resolutionName);
        this.auditService.audit(AuditEvent.builder((AuditType)RESOLUTION_REMOVED).affectedObject(this.resolutionAuditResource(resolutionId, resolutionName)).build());
    }

    @Override
    @ThrowSafe
    public void handleResolutionMoved(String id, String name, Long oldSequence, Long newSequence) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(name);
        Objects.requireNonNull(oldSequence);
        Objects.requireNonNull(newSequence);
        this.auditService.audit(AuditEvent.builder((AuditType)(oldSequence > newSequence ? RESOLUTION_MOVED_UP : RESOLUTION_MOVED_DOWN)).affectedObject(this.resolutionAuditResource(id, name)).changedValue(AuditEntitiesUtils.newChangedValue("jira.auditing.resolutions.position", oldSequence.toString(), newSequence.toString())).build());
    }

    @Override
    @ThrowSafe
    public void handleResolutionSetAsDefault(String newDefaultResolutionId, String newDefaultResolutionName, String oldDefaultResolutionId, String oldDefaultResolutionName) {
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)RESOLUTION_SET_AS_DEFAULT);
        if (!Strings.isNullOrEmpty((String)newDefaultResolutionId)) {
            builder.affectedObject(this.resolutionAuditResource(newDefaultResolutionId, newDefaultResolutionName));
        }
        this.auditService.audit(builder.changedValue(AuditEntitiesUtils.newChangedValue("jira.auditing.resolutions.default.id", oldDefaultResolutionId, newDefaultResolutionId)).changedValue(AuditEntitiesUtils.newChangedValue("jira.auditing.resolutions.default.name", oldDefaultResolutionName, newDefaultResolutionName)).build());
    }

    private AuditResource resolutionAuditResource(String resolutionId, String resolutionName) {
        return AuditResource.builder((String)resolutionName, (String)AssociatedItem.Type.RESOLUTION.name()).id(resolutionId).build();
    }
}

