/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.jira.auditing.AffectedProject;
import com.atlassian.jira.auditing.AffectedScreen;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.ScreensEventHandler;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.field.screen.AbstractFieldScreenTabEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldAddedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldMovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldRemovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabAddedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabMovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabRemovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabRenamedEvent;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.util.I18nHelper;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class ScreensEventHandlerImpl
implements ScreensEventHandler {
    private final ProjectFieldScreenHelper projectFieldScreenHelper;

    public ScreensEventHandlerImpl(ProjectFieldScreenHelper projectFieldScreenHelper) {
        this.projectFieldScreenHelper = projectFieldScreenHelper;
    }

    @Override
    public RecordRequest onFieldScreenFieldAddedEvent(FieldScreenFieldAddedEvent event) {
        ChangedValuesBuilder changedValuesBuilder = new ChangedValuesBuilder();
        changedValuesBuilder.add("common.words.name", "", event.getAffectedField().getName());
        changedValuesBuilder.add("common.words.field.id", "", event.getAffectedField().getId());
        return new RecordRequest(AuditingCategory.FIELDS, "jira.auditing.field.screen.field.added").withActionI18nKey("jira.auditing.field.screen.field.added").withChangedValues((Iterable<ChangedValue>)changedValuesBuilder.build()).forObject(new AffectedScreen(event.getTab().getFieldScreen())).withAssociatedItems(this.getAffectedProjects(event));
    }

    @Override
    public RecordRequest onFieldScreenFieldMovedEvent(FieldScreenFieldMovedEvent event) {
        ChangedValuesBuilder changedValuesBuilder1 = new ChangedValuesBuilder();
        changedValuesBuilder1.add("admin.issuefields.customfields.position", Integer.toString(event.getOldPosition()), Integer.toString(event.getNewPosition()));
        return new RecordRequest(AuditingCategory.FIELDS, "jira.auditing.field.screen.field.moved").withActionI18nKey("jira.auditing.field.screen.field.moved").withChangedValues((Iterable<ChangedValue>)changedValuesBuilder1.build()).withDescription(this.getI18n().getText("jira.auditing.field.screen.field.moved.description", event.getAffectedField().getName(), event.getAffectedField().getId())).forObject(new AffectedScreen(event.getTab().getFieldScreen())).withAssociatedItems(this.getAffectedProjects(event));
    }

    @Override
    public RecordRequest onFieldScreenFieldRemovedEvent(FieldScreenFieldRemovedEvent event) {
        ChangedValuesBuilder changedValuesBuilder = new ChangedValuesBuilder();
        changedValuesBuilder.addIfDifferent("common.words.name", event.getAffectedField().getName(), "");
        changedValuesBuilder.addIfDifferent("common.words.field.id", event.getAffectedField().getId(), "");
        return new RecordRequest(AuditingCategory.FIELDS, "jira.auditing.field.screen.field.removed").withActionI18nKey("jira.auditing.field.screen.field.removed").withChangedValues((Iterable<ChangedValue>)changedValuesBuilder.build()).forObject(new AffectedScreen(event.getTab().getFieldScreen())).withAssociatedItems(this.getAffectedProjects(event));
    }

    @Override
    public RecordRequest onFieldScreenTabAddedEvent(FieldScreenTabAddedEvent event) {
        ChangedValuesBuilder changedValuesBuilder = new ChangedValuesBuilder();
        changedValuesBuilder.add("common.words.name", "", event.getTab().getName());
        return new RecordRequest(AuditingCategory.FIELDS, "jira.auditing.field.screen.tab.added").withActionI18nKey("jira.auditing.field.screen.tab.added").withChangedValues((Iterable<ChangedValue>)changedValuesBuilder.build()).forObject(new AffectedScreen(event.getTab().getFieldScreen())).withAssociatedItems(this.getAffectedProjects(event));
    }

    @Override
    public RecordRequest onFieldScreenTabMovedEvent(FieldScreenTabMovedEvent event) {
        ChangedValuesBuilder changedValuesBuilder = new ChangedValuesBuilder();
        changedValuesBuilder.add("admin.issuefields.customfields.position", Integer.toString(event.getOldPosition()), Integer.toString(event.getNewPosition()));
        return new RecordRequest(AuditingCategory.FIELDS, "jira.auditing.field.screen.tab.moved").withActionI18nKey("jira.auditing.field.screen.tab.moved").withChangedValues((Iterable<ChangedValue>)changedValuesBuilder.build()).withDescription(this.getI18n().getText("jira.auditing.field.screen.tab.moved.description", event.getTab().getName())).forObject(new AffectedScreen(event.getTab().getFieldScreen())).withAssociatedItems(this.getAffectedProjects(event));
    }

    @Override
    public RecordRequest onFieldScreenTabRemovedEvent(FieldScreenTabRemovedEvent event) {
        ChangedValuesBuilder changedValuesBuilder = new ChangedValuesBuilder();
        changedValuesBuilder.add("common.words.name", event.getTab().getName(), "");
        return new RecordRequest(AuditingCategory.FIELDS, "jira.auditing.field.screen.tab.removed").withActionI18nKey("jira.auditing.field.screen.tab.removed").withChangedValues((Iterable<ChangedValue>)changedValuesBuilder.build()).forObject(new AffectedScreen(event.getTab().getFieldScreen())).withAssociatedItems(this.getAffectedProjects(event));
    }

    @Override
    public RecordRequest onFieldScreenTabRenamedEvent(FieldScreenTabRenamedEvent event) {
        ChangedValuesBuilder changedValuesBuilder = new ChangedValuesBuilder();
        changedValuesBuilder.addIfDifferent("common.words.name", event.getOldName(), event.getNewName());
        return new RecordRequest(AuditingCategory.FIELDS, "jira.auditing.field.screen.tab.renamed").withActionI18nKey("jira.auditing.field.screen.tab.renamed").withChangedValues((Iterable<ChangedValue>)changedValuesBuilder.build()).forObject(new AffectedScreen(event.getTab().getFieldScreen())).withAssociatedItems(this.getAffectedProjects(event));
    }

    private List<AssociatedItem> getAffectedProjects(AbstractFieldScreenTabEvent event) {
        return this.projectFieldScreenHelper.getAllProjectsForFieldScreen(event.getTab().getFieldScreen()).stream().map(AffectedProject::new).collect(Collectors.toList());
    }

    protected I18nHelper getI18n() {
        return ComponentAccessor.getI18nHelperFactory().getInstance(Locale.ENGLISH);
    }
}

