/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.jira.auditing.AffectedProject;
import com.atlassian.jira.auditing.AffectedUser;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.SharedEntityEventHandler;
import com.atlassian.jira.event.sharedentity.AbstractSharedEntityEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityCreatedEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityDeletedEvent;
import com.atlassian.jira.event.sharedentity.SharedEntityUpdatedEvent;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SharedEntityEventHandlerImpl
implements SharedEntityEventHandler {
    @VisibleForTesting
    static final String MISSING_USER = "";
    private final ShareTypeFactory shareTypeFactory;
    private final JiraAuthenticationContext authContext;
    private final ProjectManager projectManager;
    private final UserManager userManager;

    public SharedEntityEventHandlerImpl(ShareTypeFactory shareTypeFactory, JiraAuthenticationContext authContext, ProjectManager projectManager, UserManager userManager) {
        this.shareTypeFactory = shareTypeFactory;
        this.authContext = authContext;
        this.projectManager = projectManager;
        this.userManager = userManager;
    }

    @Override
    public RecordRequest onSharedEntityDeleted(SharedEntityDeletedEvent event) {
        TypeValues typeValues = new TypeValues((AbstractSharedEntityEvent)event);
        return this.onSharedEntityEvent((AbstractSharedEntityEvent)event, typeValues.getDeleteSummary(), typeValues);
    }

    @Override
    public RecordRequest onSharedEntityUpdated(SharedEntityUpdatedEvent event) {
        TypeValues typeValues = new TypeValues((AbstractSharedEntityEvent)event);
        return this.onSharedEntityEvent((AbstractSharedEntityEvent)event, typeValues.getUpdateSummary(), typeValues);
    }

    @Override
    public RecordRequest onSharedEntityCreated(SharedEntityCreatedEvent event) {
        TypeValues typeValues = new TypeValues((AbstractSharedEntityEvent)event);
        return this.onSharedEntityEvent((AbstractSharedEntityEvent)event, typeValues.getCreateSummary(), typeValues);
    }

    private RecordRequest onSharedEntityEvent(AbstractSharedEntityEvent event, @Nonnull String summary, TypeValues typeValues) {
        SharedEntity changed = event.getChangedEntity();
        HashSet<AssociatedItem> associatedItems = new HashSet<AssociatedItem>();
        ChangedValuesBuilder builder = new ChangedValuesBuilder();
        this.populateChangedValuesAndAssociatedItems(event, typeValues, builder, associatedItems);
        return new RecordRequest(typeValues.getAuditingCategory(), summary).withActionI18nKey(summary).forObject(typeValues.getAssociatedItemType(), changed.getName(), changed.getId()).withChangedValues((Iterable<ChangedValue>)builder.build()).withAssociatedItems(associatedItems);
    }

    private void populateChangedValuesAndAssociatedItems(AbstractSharedEntityEvent event, TypeValues typeValues, ChangedValuesBuilder builder, Set<AssociatedItem> associatedItems) {
        SharedEntity entityFrom = event.getEntityFrom();
        SharedEntity entityTo = event.getEntityTo();
        this.addSharedEntityValues(builder, entityFrom, entityTo, associatedItems);
        if (typeValues.isFilter()) {
            this.addSearchRequestValues(builder, (SearchRequest)entityFrom, (SearchRequest)entityTo);
        }
    }

    private void addSharedEntityValues(ChangedValuesBuilder builder, @Nullable SharedEntity entityFrom, @Nullable SharedEntity entityTo, Set<AssociatedItem> associatedItems) {
        builder.addIfDifferent("common.words.name", this.callMethodOrDefault(entityFrom, SharedEntity::getName), this.callMethodOrDefault(entityTo, SharedEntity::getName)).addIfDifferent("common.concepts.description", this.callMethodOrDefault(entityFrom, SharedEntity::getDescription), this.callMethodOrDefault(entityTo, SharedEntity::getDescription));
        this.addOwner(builder, Optional.ofNullable(entityFrom), Optional.ofNullable(entityTo), associatedItems);
        this.addPermissions(builder, entityFrom, entityTo, associatedItems);
    }

    private void addOwner(ChangedValuesBuilder builder, Optional<SharedEntity> entityFrom, Optional<SharedEntity> entityTo, Set<AssociatedItem> associatedItems) {
        Optional<ApplicationUser> ownerAfter;
        Optional<ApplicationUser> ownerBefore = this.findOwner(entityFrom);
        if (ownerBefore.equals(ownerAfter = this.findOwner(entityTo))) {
            return;
        }
        this.associateOwnerIfPresent(ownerBefore, associatedItems);
        this.associateOwnerIfPresent(ownerAfter, associatedItems);
        String ownerNameBefore = ownerBefore.map(ApplicationUser::getName).orElse(MISSING_USER);
        String ownerNameAfter = ownerAfter.map(ApplicationUser::getName).orElse(MISSING_USER);
        builder.addIfDifferent("common.concepts.owner", ownerNameBefore, ownerNameAfter);
    }

    private Optional<ApplicationUser> findOwner(Optional<SharedEntity> entity) {
        return entity.map(SharedEntity::getOwner).map(u -> this.userManager.getUserByKey(u.getKey()));
    }

    private void associateOwnerIfPresent(Optional<ApplicationUser> owner, Set<AssociatedItem> associatedItems) {
        if (owner.isPresent()) {
            associatedItems.add(new AffectedUser(owner.get()));
        }
    }

    private void addPermissions(ChangedValuesBuilder builder, SharedEntity entityFrom, SharedEntity entityTo, Set<AssociatedItem> associatedItems) {
        Function<SharedEntity, List> permissions = e -> Lists.newArrayList((Iterable)e.getPermissions());
        List<SharePermission> permissionsBefore = this.callMethodOrDefaultList(entityFrom, permissions);
        List<SharePermission> permissionsAfter = this.callMethodOrDefaultList(entityTo, permissions);
        ArrayList<SharePermission> permissionsBeforeUnmodifiable = new ArrayList<SharePermission>(permissionsBefore);
        builder.addIfDifferent("common.concepts.shared.with", this.getUniquePermissionsChange(permissionsBefore, permissionsAfter, associatedItems), this.getUniquePermissionsChange(permissionsAfter, permissionsBeforeUnmodifiable, associatedItems));
    }

    private String getUniquePermissionsChange(List<SharePermission> permissionsBase, List<SharePermission> permissionsDuplicates, Set<AssociatedItem> associatedItems) {
        permissionsBase.removeAll(permissionsDuplicates);
        this.addAssociatedPermissions(permissionsBase, associatedItems);
        return this.getPermissions(permissionsBase);
    }

    private void addAssociatedPermissions(List<SharePermission> permissions, Set<AssociatedItem> associatedItems) {
        permissions.forEach(sharePermission -> {
            ApplicationUser user;
            Project project;
            ShareType.Name type = sharePermission.getType();
            if (type.equals((Object)ShareType.Name.PROJECT) && (project = this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(sharePermission.getParam1())))) != null) {
                associatedItems.add(new AffectedProject(project));
            }
            if (type.equals((Object)ShareType.Name.USER) && (user = this.userManager.getUserByKey(sharePermission.getParam1())) != null) {
                associatedItems.add(new AffectedUser(user));
            }
        });
    }

    private void addSearchRequestValues(ChangedValuesBuilder builder, @Nullable SearchRequest entityFrom, @Nullable SearchRequest entityTo) {
        Function<SearchRequest, String> query = e -> e.getQuery().toString();
        builder.addIfDifferent("jira.jql.query", this.callMethodOrDefault(entityFrom, query), this.callMethodOrDefault(entityTo, query));
    }

    private String getPermissions(List<SharePermission> sharePermissions) {
        sharePermissions.sort(this.shareTypeFactory.getPermissionComparator());
        return sharePermissions.stream().map(sharePermission -> {
            ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
            ShareTypeRenderer shareTypeRenderer = type.getRenderer();
            return this.removeHtmlTags(shareTypeRenderer.renderPermission(sharePermission, this.authContext));
        }).collect(Collectors.toList()).toString();
    }

    private String removeHtmlTags(String permissionDescWithHtmlTags) {
        return permissionDescWithHtmlTags.replaceAll("<.*?>", MISSING_USER);
    }

    private <T extends SharedEntity> String callMethodOrDefault(T entity, Function<T, String> func) {
        return entity == null ? MISSING_USER : func.apply(entity);
    }

    private <T extends SharedEntity> List<SharePermission> callMethodOrDefaultList(T entity, Function<T, List<SharePermission>> func) {
        return entity == null ? Collections.EMPTY_LIST : func.apply(entity);
    }

    private class TypeValues {
        private final boolean isFilter;

        TypeValues(AbstractSharedEntityEvent event) {
            SharedEntity changed = event.getChangedEntity();
            boolean isDashboard = changed instanceof PortalPage;
            this.isFilter = changed instanceof SearchRequest;
            if (isDashboard == this.isFilter) {
                throw new IllegalArgumentException("Wrong shared entity event type! Found: " + event.getChangedEntity().getClass() + ". Expected " + PortalPage.class + " or " + SearchRequest.class);
            }
        }

        String getDeleteSummary() {
            return this.getFilterOrDashboardProperty("jira.auditing.filter.deleted", "jira.auditing.dashboard.deleted");
        }

        String getUpdateSummary() {
            return this.getFilterOrDashboardProperty("jira.auditing.filter.updated", "jira.auditing.dashboard.updated");
        }

        String getCreateSummary() {
            return this.getFilterOrDashboardProperty("jira.auditing.filter.created", "jira.auditing.dashboard.created");
        }

        AuditingCategory getAuditingCategory() {
            return this.getFilterOrDashboardProperty(AuditingCategory.FILTERS, AuditingCategory.DASHBOARDS);
        }

        AssociatedItem.Type getAssociatedItemType() {
            return this.getFilterOrDashboardProperty(AssociatedItem.Type.FILTER, AssociatedItem.Type.DASHBOARD);
        }

        private <T> T getFilterOrDashboardProperty(T filterProperty, T dashboardProperty) {
            return this.isFilter ? filterProperty : dashboardProperty;
        }

        boolean isFilter() {
            return this.isFilter;
        }
    }
}

