/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.handlers.StatusEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.fields.StatusCreatedEvent;
import com.atlassian.jira.event.fields.StatusDeletedEvent;
import com.atlassian.jira.event.fields.StatusEditedEvent;
import com.atlassian.jira.event.fields.StatusMovedEvent;

@AuditExceptionSafe
public class StatusEventHandlerImpl
implements StatusEventHandler {
    private static final AuditType STATUS_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.fields", "jira.auditing.status.created", CoverageLevel.ADVANCED);
    private static final AuditType STATUS_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.fields", "jira.auditing.status.updated", CoverageLevel.ADVANCED);
    private static final AuditType STATUS_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.fields", "jira.auditing.status.deleted", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final String I18N_STATUS_ORDER_CHANGED = "jira.auditing.status.order.changed";
    private static final AuditType STATUS_ORDER_CHANGED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.fields", "jira.auditing.status.order.changed", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final String I18N_STATUS_NAME = "jira.auditing.status.name";
    @VisibleForTesting
    static final String I18N_STATUS_CATEGORY = "jira.auditing.status.category";
    @VisibleForTesting
    static final String I18N_STATUS_DESCRIPTION = "jira.auditing.status.description";
    @VisibleForTesting
    static final String I18N_STATUS_SEQUENCE = "jira.auditing.status.sequence";
    private final AuditService auditService;

    public StatusEventHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void handleStatusCreated(StatusCreatedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)STATUS_CREATED).affectedObject(AuditResource.builder((String)event.getStatus().getName(), (String)AssociatedItem.Type.STATUS.name()).id(event.getStatus().getId()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_STATUS_NAME, event.getStatus().getName())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_STATUS_DESCRIPTION, event.getStatus().getDescription())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(I18N_STATUS_CATEGORY, event.getStatus().getStatusCategory().getPrimaryAlias())).build());
    }

    @Override
    @ThrowSafe
    public void handleStatusEdited(StatusEditedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)STATUS_UPDATED).affectedObject(AuditResource.builder((String)event.getUpdatedStatus().getName(), (String)AssociatedItem.Type.STATUS.name()).id(event.getUpdatedStatus().getId()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)I18N_STATUS_NAME).from(event.getOriginalStatus().getName()).to(event.getUpdatedStatus().getName()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)I18N_STATUS_DESCRIPTION).from(event.getOriginalStatus().getDescription()).to(event.getUpdatedStatus().getDescription()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)I18N_STATUS_CATEGORY).from(event.getOriginalStatus().getStatusCategory().getPrimaryAlias()).to(event.getUpdatedStatus().getStatusCategory().getPrimaryAlias()).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleStatusDeleted(StatusDeletedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)STATUS_DELETED).affectedObject(AuditResource.builder((String)event.getStatus().getName(), (String)AssociatedItem.Type.STATUS.name()).build()).build());
    }

    @Override
    @ThrowSafe
    public void handleStatusMoved(StatusMovedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)STATUS_ORDER_CHANGED).affectedObject(AuditResource.builder((String)event.getStatus().getName(), (String)AssociatedItem.Type.STATUS.name()).id(event.getStatus().getId()).build()).changedValue(ChangedValue.fromI18nKeys((String)I18N_STATUS_SEQUENCE).from(event.getFrom().toString()).to(event.getTo().toString()).build()).build());
    }
}

