/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.handlers.TerminologyAuditHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.i18n.terminology.TerminologyEntryChangedEvent;

@AuditExceptionSafe
public class TerminologyAuditHandlerImpl
implements TerminologyAuditHandler {
    private static final String CHANGED_KEY = "jira.auditing.terminology.changed";
    @VisibleForTesting
    static final String ORIGINAL_NAME_KEY = "jira.auditing.terminology.name.original";
    @VisibleForTesting
    static final String NEW_NAME_KEY = "jira.auditing.terminology.name.new";
    @VisibleForTesting
    static final String NEW_NAME_PLURAL_KEY = "jira.auditing.terminology.name.new.plural";
    @VisibleForTesting
    static final String AUDIT_TYPE = "Terminology";
    @VisibleForTesting
    static final AuditType TERMINOLOGY_ENTRY_CHANGED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.terminology", "jira.auditing.terminology.changed", CoverageLevel.BASE);
    private final AuditService auditService;

    public TerminologyAuditHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    public void handleTerminologyEntryChangedEvent(TerminologyEntryChangedEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)TERMINOLOGY_ENTRY_CHANGED).affectedObject(AuditEntitiesUtils.newAuditResource(event.getOriginalName(), AUDIT_TYPE, event.getOriginalName())).addChangedValueIfDifferent(AuditEntitiesUtils.newChangedValue(NEW_NAME_KEY, event.getOldName(), event.getNewName())).addChangedValueIfDifferent(AuditEntitiesUtils.newChangedValue(NEW_NAME_PLURAL_KEY, event.getOldNamePlural(), event.getNewNamePlural())).extraAttribute(AuditEntitiesUtils.newAuditAttribute(ORIGINAL_NAME_KEY, event.getOriginalName())).build());
    }
}

