/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.jira.auditing.ChangedValuesBuilder;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public interface TimeTrackingHandler {
    public void handleTimeTrackingEnabled(@Nonnull TimeTrackingHandlerData var1);

    public void handleTimeTrackingDisabled(@Nonnull TimeTrackingHandlerData var1);

    public static class TimeTrackingHandlerData {
        private final String hoursPerDay;
        private final String daysPerWeek;
        private final String timeTrackingFormat;
        private final String defaultUnit;
        private final boolean legacyModeSetter;
        private final boolean copyCommentToWorkDecription;

        public TimeTrackingHandlerData(String hoursPerDay, String daysPerWeek, String timeTrackingFormat, String defaultUnit, boolean legacyModeSetter, boolean copyCommentToWorkDecription) {
            this.hoursPerDay = hoursPerDay;
            this.daysPerWeek = daysPerWeek;
            this.timeTrackingFormat = timeTrackingFormat;
            this.defaultUnit = defaultUnit;
            this.legacyModeSetter = legacyModeSetter;
            this.copyCommentToWorkDecription = copyCommentToWorkDecription;
        }

        public List<ChangedValue> toChangeValuesEnabled() {
            return new ChangedValuesBuilder().add("admin.globalsettings.timetracking.hours.per.day", this.hoursPerDay).add("admin.globalsettings.timetracking.days.per.week", this.daysPerWeek).add("admin.globalsettings.timetracking.format.label", this.timeTrackingFormat).add("admin.globalsettings.timetracking.default.unit.label", this.defaultUnit).add("admin.globalsettings.timetracking.legacy.mode.fieldname", Boolean.toString(this.legacyModeSetter)).add("admin.globalsettings.timetracking.copy.comment.fieldname", Boolean.toString(this.copyCommentToWorkDecription)).build();
        }

        public List<ChangedValue> toChangeValuesDisabled() {
            return new ChangedValuesBuilder().add("admin.globalsettings.timetracking.hours.per.day", this.hoursPerDay, null).add("admin.globalsettings.timetracking.days.per.week", this.daysPerWeek, null).add("admin.globalsettings.timetracking.format.label", this.timeTrackingFormat, null).add("admin.globalsettings.timetracking.default.unit.label", this.defaultUnit, null).add("admin.globalsettings.timetracking.legacy.mode.fieldname", Boolean.toString(this.legacyModeSetter), null).add("admin.globalsettings.timetracking.copy.comment.fieldname", Boolean.toString(this.copyCommentToWorkDecription), null).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeTrackingHandlerData that = (TimeTrackingHandlerData)o;
            return this.legacyModeSetter == that.legacyModeSetter && this.copyCommentToWorkDecription == that.copyCommentToWorkDecription && Objects.equals(this.hoursPerDay, that.hoursPerDay) && Objects.equals(this.daysPerWeek, that.daysPerWeek) && Objects.equals(this.timeTrackingFormat, that.timeTrackingFormat) && Objects.equals(this.defaultUnit, that.defaultUnit);
        }

        public int hashCode() {
            return Objects.hash(this.hoursPerDay, this.daysPerWeek, this.timeTrackingFormat, this.defaultUnit, this.legacyModeSetter, this.copyCommentToWorkDecription);
        }

        public String toString() {
            return "TimeTrackingHandlerData{hoursPerDay='" + this.hoursPerDay + "', daysPerWeek='" + this.daysPerWeek + "', timeTrackingFormat='" + this.timeTrackingFormat + "', defaultUnit='" + this.defaultUnit + "', legacyModeSetter=" + this.legacyModeSetter + ", copyCommentToWorkDecription=" + this.copyCommentToWorkDecription + "}";
        }
    }
}

