/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.UserDefaultSettingsEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.user.UserDefaultSettingsUpdatedEvent;
import com.atlassian.jira.user.UserDefaultSettings;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;

@AuditExceptionSafe
public class UserDefaultSettingsEventHandlerImpl
implements UserDefaultSettingsEventHandler {
    @VisibleForTesting
    static final AuditType DEFAULT_USER_SETTINGS_CHANGED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, "jira.auditing.category.userinterface", "jira.auditing.default.user.settings.changed", CoverageLevel.ADVANCED);
    private final I18nHelper i18nHelper;
    private final AuditService auditService;

    public UserDefaultSettingsEventHandlerImpl(I18nHelper i18nHelper, AuditService auditService) {
        this.i18nHelper = i18nHelper;
        this.auditService = auditService;
    }

    @Override
    public RecordRequest onUserDefaultSettingsUpdatedEvent(UserDefaultSettingsUpdatedEvent event) {
        return new RecordRequest("jira.auditing.category.userinterface", "jira.auditing.default.user.settings.changed").withActionI18nKey("jira.auditing.default.user.settings.changed").withChangedValues(this.getChangeValues(event));
    }

    @Override
    @ThrowSafe
    public void handleUserDefaultSettingsUpdatedEvent(UserDefaultSettingsUpdatedEvent event) {
        UserDefaultSettings from = event.getPreviousSettings();
        UserDefaultSettings to = event.getCurrentSettings();
        this.auditService.audit(AuditEvent.builder((AuditType)DEFAULT_USER_SETTINGS_CHANGED).changedValues(new com.atlassian.jira.auditing.ChangedValuesBuilder().addIfDifferent("admin.userdefaults.outgoing.email.format", from.getPreferences(), to.getPreferences()).addIfDifferent("admin.userdefaults.number.of.issues", Objects.toString(from.getIssuesPerPage(), null), Objects.toString(to.getIssuesPerPage(), null)).addIfDifferent("admin.userdefaults.default.share", this.yesNoEmpty(from.isSharePrivateEnabled(), this.i18nHelper.getText("admin.common.words.private"), this.i18nHelper.getText("admin.common.words.public")), this.yesNoEmpty(to.isSharePrivateEnabled(), this.i18nHelper.getText("admin.common.words.private"), this.i18nHelper.getText("admin.common.words.public"))).addIfDifferent("admin.userdefaults.notify.users.of.own.changes", this.yesNoEmpty(from.isNotifyUserAboutOwnChangesEnabled(), this.i18nHelper.getText("common.words.yes"), this.i18nHelper.getText("common.words.no")), this.yesNoEmpty(to.isNotifyUserAboutOwnChangesEnabled(), this.i18nHelper.getText("common.words.yes"), this.i18nHelper.getText("common.words.no"))).addIfDifferent("admin.userdefaults.labels.autowatch", this.yesNoEmpty(from.isAutowatchEnabled(), this.i18nHelper.getText("common.words.yes"), this.i18nHelper.getText("common.words.no")), this.yesNoEmpty(to.isAutowatchEnabled(), this.i18nHelper.getText("common.words.yes"), this.i18nHelper.getText("common.words.no"))).build()).build());
    }

    private String yesNoEmpty(Boolean b, String yesString, String noString) {
        if (b == null) {
            return null;
        }
        return b != false ? yesString : noString;
    }

    private List<ChangedValue> getChangeValues(UserDefaultSettingsUpdatedEvent event) {
        UserDefaultSettings from = event.getPreviousSettings();
        UserDefaultSettings to = event.getCurrentSettings();
        ChangedValuesBuilder builder = new ChangedValuesBuilder();
        builder.addIfDifferent("admin.userdefaults.outgoing.email.format", from.getPreferences(), to.getPreferences());
        builder.addIfDifferent("admin.userdefaults.number.of.issues", from.getIssuesPerPage().toString(), to.getIssuesPerPage().toString());
        builder.addIfDifferent("admin.userdefaults.default.share", from.isSharePrivateEnabled() != false ? this.i18nHelper.getText("admin.common.words.private") : this.i18nHelper.getText("admin.common.words.public"), to.isSharePrivateEnabled() != false ? this.i18nHelper.getText("admin.common.words.private") : this.i18nHelper.getText("admin.common.words.public"));
        builder.addIfDifferent("admin.userdefaults.notify.users.of.own.changes", from.isNotifyUserAboutOwnChangesEnabled() != false ? this.i18nHelper.getText("common.words.yes") : this.i18nHelper.getText("common.words.no"), to.isNotifyUserAboutOwnChangesEnabled() != false ? this.i18nHelper.getText("common.words.yes") : this.i18nHelper.getText("common.words.no"));
        builder.addIfDifferent("admin.userdefaults.labels.autowatch", from.isAutowatchEnabled() != false ? this.i18nHelper.getText("common.words.yes") : this.i18nHelper.getText("common.words.no"), to.isAutowatchEnabled() != false ? this.i18nHelper.getText("common.words.yes") : this.i18nHelper.getText("common.words.no"));
        return builder.build();
    }
}

