/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.legacy;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditEntityCursor;
import com.atlassian.audit.api.AuditQuery;
import com.atlassian.audit.api.AuditSearchService;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.api.util.pagination.Page;
import com.atlassian.audit.api.util.pagination.PageRequest;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditRecord;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.AuditingEntry;
import com.atlassian.jira.auditing.AuditingFilter;
import com.atlassian.jira.auditing.AuditingStore;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.Records;
import com.atlassian.jira.auditing.converters.AuditEvents;
import com.atlassian.jira.auditing.converters.AuditRecords;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;

public class AuditingStoreToAuditServiceImpl
implements AuditingStore {
    private final AuditService auditService;
    private final AuditEvents auditEvents;
    public static final int MAX_RESULTS_LIMIT = 10000;

    public AuditingStoreToAuditServiceImpl(AuditService auditService, AuditEvents auditEvents) {
        this.auditService = auditService;
        this.auditEvents = auditEvents;
    }

    @Override
    public void storeRecord(@Nonnull AuditingCategory category, String categoryName, @Nonnull String summaryI18nKey, @Nonnull String eventSource, @Nullable ApplicationUser author, @Nullable String remoteAddress, @Nullable AssociatedItem object, @Nullable Iterable<ChangedValue> changedValues, @Nullable Iterable<AssociatedItem> associatedItems, boolean isAuthorSysAdmin) {
        AuditingEntry entry = AuditingEntry.builder(category, summaryI18nKey, eventSource).categoryName(categoryName).author(author).remoteAddress(remoteAddress).objectItem(object).changedValues(changedValues).associatedItems(associatedItems).isAuthorSysAdmin(isAuthorSysAdmin).build();
        this.storeRecord(entry);
    }

    @Override
    public void storeRecord(@Nonnull AuditingEntry entry) {
        this.auditService.audit(this.auditEvents.from(entry));
    }

    @Override
    @Nonnull
    public Records getRecords(@Nullable Long maxId, @Nullable Long sinceId, @Nullable Integer maxResults, @Nullable Integer offset, @Nullable AuditingFilter filter, boolean includeSysAdminActions) {
        try {
            PageRequest<AuditEntityCursor> auditEntityCursorPageRequest = this.createAuditEntityCursorPageRequest(maxResults, offset);
            AuditQuery auditQuery = this.createAuditQuery(maxId, sinceId, filter);
            Page auditEntityCursorPage = this.getAuditSearchService().findBy(auditQuery, auditEntityCursorPageRequest);
            final List auditRecords = this.filterProjects(auditEntityCursorPage.getValues(), filter).stream().map(AuditRecords::from).collect(Collectors.toList());
            return new Records(){

                @Override
                public Iterable<AuditRecord> getRecords() {
                    return auditRecords;
                }

                @Override
                public List<AuditRecord> getResults() {
                    return auditRecords;
                }

                @Override
                public long getCount() {
                    return auditRecords.size();
                }

                @Override
                public int getMaxResults() {
                    return 10000;
                }
            };
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long countRecords(@Nullable Long maxId, @Nullable Long sinceId, boolean includeSysAdminActions) {
        try {
            return this.getAuditSearchService().count(this.createAuditQuery(maxId, sinceId));
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long removeRecordsOlderThan(long timestamp) {
        return 0L;
    }

    @Override
    public long countRecordsOlderThan(long timestamp) {
        try {
            return this.getAuditSearchService().count(AuditQuery.builder().from(Instant.ofEpochMilli(timestamp)).build());
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private List<AuditEntity> filterProjects(List<AuditEntity> values, AuditingFilter filter) {
        if (!values.isEmpty() && filter != null && filter.hasProjectIds().booleanValue()) {
            List projectIds = filter.getProjectIds().stream().filter(Objects::nonNull).map(Objects::toString).collect(Collectors.toList());
            return values.stream().filter(auditEntity -> auditEntity.getAffectedObjects().stream().anyMatch(auditResource -> auditResource.getType().equals(AssociatedItem.Type.PROJECT.name()) && projectIds.contains(auditResource.getId()))).collect(Collectors.toList());
        }
        return values;
    }

    private PageRequest<AuditEntityCursor> createAuditEntityCursorPageRequest(@Nullable Integer maxResults, @Nullable Integer offset) {
        PageRequest.Builder auditEntityCursorBuilder = new PageRequest.Builder();
        Optional.ofNullable(offset).ifPresent(arg_0 -> ((PageRequest.Builder)auditEntityCursorBuilder).offset(arg_0));
        return auditEntityCursorBuilder.limit(((Integer)ObjectUtils.min((Comparable[])new Integer[]{maxResults, 10000})).intValue()).build();
    }

    private AuditQuery createAuditQuery(@Nullable Long maxId, @Nullable Long sinceId) {
        AuditQuery.Builder auditQueryBuilder = AuditQuery.builder();
        Optional.ofNullable(sinceId).ifPresent(arg_0 -> ((AuditQuery.Builder)auditQueryBuilder).minId(arg_0));
        Optional.ofNullable(maxId).ifPresent(arg_0 -> ((AuditQuery.Builder)auditQueryBuilder).maxId(arg_0));
        return auditQueryBuilder.build();
    }

    private AuditQuery createAuditQuery(@Nullable Long maxId, @Nullable Long sinceId, @Nullable AuditingFilter filter) {
        AuditQuery.Builder auditQueryBuilder = AuditQuery.builder();
        Optional.ofNullable(sinceId).ifPresent(arg_0 -> ((AuditQuery.Builder)auditQueryBuilder).minId(arg_0));
        Optional.ofNullable(maxId).ifPresent(arg_0 -> ((AuditQuery.Builder)auditQueryBuilder).maxId(arg_0));
        if (filter != null) {
            Optional.ofNullable(filter.getFilter()).ifPresent(arg_0 -> ((AuditQuery.Builder)auditQueryBuilder).searchText(arg_0));
            Optional.ofNullable(filter.getUserIds()).map(users -> users.toArray(new String[0])).ifPresent(arg_0 -> ((AuditQuery.Builder)auditQueryBuilder).userIds(arg_0));
            Optional.ofNullable(filter.getFromTimestamp()).map(Instant::ofEpochMilli).ifPresent(arg_0 -> ((AuditQuery.Builder)auditQueryBuilder).from(arg_0));
            Optional.ofNullable(filter.getToTimestamp()).map(Instant::ofEpochMilli).ifPresent(arg_0 -> ((AuditQuery.Builder)auditQueryBuilder).to(arg_0));
        }
        return auditQueryBuilder.build();
    }

    @VisibleForTesting
    protected AuditSearchService getAuditSearchService() {
        return (AuditSearchService)ComponentAccessor.getOSGiComponentInstanceOfType(AuditSearchService.class);
    }
}

