/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.lookup;

import com.atlassian.audit.api.util.pagination.Page;
import com.atlassian.audit.api.util.pagination.PageRequest;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.spi.lookup.AuditingResourcesLookupService;
import com.atlassian.jira.auditing.converters.AuditAuthors;
import com.atlassian.jira.auditing.spis.lookup.PagedLookupSupport;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.model.querydsl.QProject;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JiraAuditingResourcesLookupServiceImpl
implements AuditingResourcesLookupService {
    private static final String DELIMS = "-_/\\,+=&^%$#*@!~`'\":;<> ";
    public static final QProject PROJECT = new QProject("PROJECT");
    @VisibleForTesting
    static final UserSearchParams USER_SEARCH_PARAMS = UserSearchParams.builder().allowEmptyQuery(true).includeActive(true).includeInactive(true).build();
    private final UserSearchService userSearchService;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;

    public JiraAuditingResourcesLookupServiceImpl(UserSearchService userSearchService, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.userSearchService = userSearchService;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
    }

    public Page<AuditAuthor, String> lookupAuditAuthor(@Nullable String searchText, @Nonnull PageRequest<String> pageRequest) {
        PagedLookupSupport<ApplicationUser, AuditAuthor> pss = new PagedLookupSupport<ApplicationUser, AuditAuthor>(text -> this.findApplicationUsers((String)text, UserSearchParams.builder((UserSearchParams)USER_SEARCH_PARAMS).limitResults(pageRequest.getLimit()).build()), ApplicationUser::getName, AuditAuthors::from);
        return pss.lookupPage(searchText, pageRequest);
    }

    private List<ApplicationUser> findApplicationUsers(@Nullable String searchText, UserSearchParams userSearchParams) {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        return this.userSearchService.findUsers((JiraServiceContext)new JiraServiceContextImpl(loggedInUser), searchText, userSearchParams);
    }

    public Page<AuditResource, String> lookupAuditResource(@Nonnull String resourceType, @Nullable String searchText, @Nonnull PageRequest<String> pageRequest) {
        PagedLookupSupport<Project, AuditResource> pss = new PagedLookupSupport<Project, AuditResource>(this::findProjects, Project::getName, this::fromProject);
        return pss.lookupPage(searchText, pageRequest);
    }

    private List<Project> findProjects(String searchText) {
        return this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.authenticationContext.getLoggedInUser()).stream().filter(project -> this.projectMatches((Project)project, searchText)).collect(Collectors.toList());
    }

    private AuditResource fromProject(Project project) {
        return AuditResource.builder((String)project.getName(), (String)"PROJECT").id(String.valueOf(project.getId())).uri(project.getUrl()).build();
    }

    private boolean projectMatches(Project project, String query) {
        query = query.toLowerCase().trim();
        String projectName = project.getName().toLowerCase();
        String projectKey = project.getKey().toLowerCase();
        if (projectName.startsWith(query) || projectKey.startsWith(query)) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(project.getName().toLowerCase(), DELIMS);
        while (tokenizer.hasMoreElements()) {
            String projPart = tokenizer.nextToken();
            if (!projPart.startsWith(query)) continue;
            return true;
        }
        return false;
    }
}

